/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.common.FilteringDialog;
import jp.co.argo21.nautica.tool.wfadm.common.PropertyDialog;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineNode;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewController;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessDefinitionFilteringComponent;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessDefinitionFlowPanel;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessDefinitionNode;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessFilteringComponent;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessFlowPanel;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessNode;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

public class EngineViewFrame
extends JInternalFrame {
    private static final Color BACKGROUND = Color.white;
    private static final Color PROC_COMPLETED_BACKGROUND = new Color(230, 230, 230);
    private static final Color PROC_TERMINATED_BACKGROUND = new Color(255, 255, 230);
    private static final Color PROC_ABORTED_BACKGROUND = new Color(255, 230, 230);
    private EngineViewController engineViewController;
    private JSplitPane splitPane;
    private JTree tree;
    private JTabbedPane tabbedPane;
    private JPopupMenu enginePopup;
    private JPopupMenu procDefPopup;
    private JPopupMenu procPopup;

    public EngineViewFrame(String title, EngineViewController evc) {
        super(title, true, true, true, true);
        this.engineViewController = evc;
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.setFrameIcon(IconManager.getIcon("process-frameicon"));
        this.createEnginePopup(rm);
        this.createProcessDefinitionPopup(rm);
        this.createProcessPopup(rm);
        EngineTreeListner listener = new EngineTreeListner();
        EngineNode root = new EngineNode(this);
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree = new JTree(model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeWillExpandListener(listener);
        this.tree.addMouseListener(listener);
        this.tree.setCellRenderer(new EngineTreeCellRenderer());
        JScrollPane sp = new JScrollPane(this.tree);
        sp.setPreferredSize(new Dimension(200, 200));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addMouseListener(new TabMouseAdapter());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(sp);
        this.splitPane.setRightComponent(this.tabbedPane);
        Container contentPane = this.getContentPane();
        BorderLayout layout = new BorderLayout();
        contentPane.setLayout(layout);
        contentPane.add((Component)this.splitPane, "Center");
        this.setSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameOpened(InternalFrameEvent e) {
                EngineViewFrame.this.opened();
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                EngineViewFrame.this.activated();
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                EngineViewFrame.this.deactivated();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                EngineViewFrame.this.close();
            }
        });
        this.validate();
    }

    void opened() {
    }

    void activated() {
    }

    void deactivated() {
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    EngineViewController getEngineViewController() {
        return this.engineViewController;
    }

    private Color getBackgroundColor(Process proc) {
        if (proc == null) {
            return BACKGROUND;
        }
        int state = proc.getProcessState();
        if (state == ProcessState.CLOSED_COMPLETED.toInt()) {
            return PROC_COMPLETED_BACKGROUND;
        }
        if (state == ProcessState.CLOSED_TERMINATED.toInt()) {
            return PROC_TERMINATED_BACKGROUND;
        }
        if (state == ProcessState.CLOSED_ABORTED.toInt()) {
            return PROC_ABORTED_BACKGROUND;
        }
        return BACKGROUND;
    }

    private void createEnginePopup(ResourceManager rm) {
        this.enginePopup = new JPopupMenu();
        JMenuItem item1 = new JMenuItem(rm.getResource("EngineViewFrame.popup.3"));
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                EngineNode node = (EngineNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                ProcessDefinitionFilteringComponent c = new ProcessDefinitionFilteringComponent();
                Filter filter = FilteringDialog.showDialog(EngineViewFrame.this, c);
                NodeReloadTask task = new NodeReloadTask(node, filter);
                WorkflowAdminManager.runBusyTask(task);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        JMenuItem item2 = new JMenuItem(rm.getResource("EngineViewFrame.popup.0"));
        item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                EngineNode node = (EngineNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                Properties prop = node.getProperties(rm);
                PropertyDialog.showDialog((Component)EngineViewFrame.this, node.toString(), prop);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        this.enginePopup.add(item1);
        this.enginePopup.add(item2);
    }

    private void createProcessDefinitionPopup(ResourceManager rm) {
        this.procDefPopup = new JPopupMenu();
        JMenuItem item1 = new JMenuItem(rm.getResource("EngineViewFrame.popup.1"));
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                ProcessDefinitionNode node = (ProcessDefinitionNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                ShowProcessDefinitionFlowTask task = new ShowProcessDefinitionFlowTask(node);
                WorkflowAdminManager.runBusyTask(task);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        JMenuItem item2 = new JMenuItem(rm.getResource("EngineViewFrame.popup.3"));
        item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                ProcessDefinitionNode node = (ProcessDefinitionNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                ProcessFilteringComponent c = new ProcessFilteringComponent();
                Filter filter = FilteringDialog.showDialog(EngineViewFrame.this, c);
                NodeReloadTask task = new NodeReloadTask(node, filter);
                WorkflowAdminManager.runBusyTask(task);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        JMenuItem item3 = new JMenuItem(rm.getResource("EngineViewFrame.popup.0"));
        item3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                ProcessDefinitionNode node = (ProcessDefinitionNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                Properties prop = node.getProperties(rm);
                PropertyDialog.showDialog((Component)EngineViewFrame.this, node.toString(), prop);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        this.procDefPopup.add(item1);
        this.procDefPopup.add(item2);
        this.procDefPopup.add(item3);
    }

    private void createProcessPopup(ResourceManager rm) {
        this.procPopup = new JPopupMenu();
        JMenuItem item1 = new JMenuItem(rm.getResource("EngineViewFrame.popup.2"));
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                ProcessNode node = (ProcessNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                ShowProcessFlowTask task = new ShowProcessFlowTask(node);
                WorkflowAdminManager.runBusyTask(task);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        JMenuItem item2 = new JMenuItem(rm.getResource("EngineViewFrame.popup.0"));
        item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                TreePath path = EngineViewFrame.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                ProcessNode node = (ProcessNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                Process p = node.getProcess();
                ProcessLoadTask task = new ProcessLoadTask(p);
                WorkflowAdminManager.runBusyTask(task);
                Process rp = task.getProcess();
                node.setProcess(rp);
                Properties prop = node.getProperties(rm);
                PropertyDialog.showDialog((Component)EngineViewFrame.this, node.toString(), prop);
                EngineViewFrame.this.updateEngineTree();
            }
        });
        this.procPopup.add(item1);
        this.procPopup.add(item2);
    }

    private void updateEngineTree() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                EngineViewFrame.this.tree.updateUI();
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private int getProcessDefinitionTabIndex(String pdname) {
        Component[] comps = this.tabbedPane.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            String n;
            if (!(comps[i] instanceof ProcessDefinitionFlowPanel) || !(n = ((ProcessDefinitionFlowPanel)comps[i]).getProcessDefinitionName()).equals(pdname)) continue;
            return i;
        }
        return -1;
    }

    private int getProcessTabIndex(String pid) {
        Component[] comps = this.tabbedPane.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            String n;
            if (!(comps[i] instanceof ProcessFlowPanel) || !(n = ((ProcessFlowPanel)comps[i]).getProcessID()).equals(pid)) continue;
            return i;
        }
        return -1;
    }

    class ProcessLoadTask
    implements BusyTask {
        private int state = 0;
        private Process process;

        ProcessLoadTask(Process proc) {
            this.process = proc;
        }

        public int getState() {
            return this.state;
        }

        Process getProcess() {
            return this.process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            try {
                this.process = EngineViewFrame.this.engineViewController.getProcess(this.process.getID());
            }
            catch (Exception ex) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9033"));
            }
            finally {
                this.state = 2;
            }
        }
    }

    class ShowProcessFlowTask
    implements BusyTask {
        private ProcessNode node;
        private int state = 0;

        ShowProcessFlowTask(ProcessNode node) {
            this.node = node;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            Process proc = this.node.getProcess();
            String pname = proc.getName();
            String pid = proc.getID();
            String label = pname + "(" + pid + ")";
            String pdname = proc.getProcDefinitionID();
            try {
                int ix = EngineViewFrame.this.getProcessTabIndex(pid);
                if (ix < 0) {
                    PackageDefinition def = EngineViewFrame.this.engineViewController.getPackgeDefinition(pdname);
                    if (def == null) {
                        DialogUtilities.showError(rm.getResource("E9019") + "(" + pname + ")");
                        return;
                    }
                    ProcessFlowPanel panel = new ProcessFlowPanel(EngineViewFrame.this, proc, def);
                    EngineViewFrame.this.tabbedPane.add(label, panel);
                    EngineViewFrame.this.tabbedPane.setSelectedComponent(panel);
                } else {
                    EngineViewFrame.this.tabbedPane.setSelectedIndex(ix);
                }
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9019") + "(" + pname + ")");
            }
            finally {
                this.state = 2;
            }
        }
    }

    class ShowProcessDefinitionFlowTask
    implements BusyTask {
        private ProcessDefinitionNode node;
        private int state = 0;

        ShowProcessDefinitionFlowTask(ProcessDefinitionNode node) {
            this.node = node;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            ProcDef pd = this.node.getProcDef();
            String pdname = pd.getID();
            try {
                int ix = EngineViewFrame.this.getProcessDefinitionTabIndex(pdname);
                if (ix < 0) {
                    PackageDefinition def = EngineViewFrame.this.engineViewController.getPackgeDefinition(pdname);
                    if (def == null) {
                        DialogUtilities.showError(rm.getResource("E9016") + "(" + pdname + ")");
                        return;
                    }
                    ProcessDefinitionFlowPanel panel = new ProcessDefinitionFlowPanel(EngineViewFrame.this, pd, def);
                    EngineViewFrame.this.tabbedPane.add(pdname, panel);
                    EngineViewFrame.this.tabbedPane.setSelectedComponent(panel);
                } else {
                    EngineViewFrame.this.tabbedPane.setSelectedIndex(ix);
                }
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9016") + "(" + pdname + ")");
            }
            finally {
                this.state = 2;
            }
        }
    }

    class NodeReloadTask
    implements BusyTask {
        private EngineTreeNode node;
        private Filter filter;
        private int state = 0;

        NodeReloadTask(EngineTreeNode node, Filter filter) {
            this.node = node;
            this.filter = filter;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            try {
                this.node.reload(this.filter);
            }
            catch (Exception ex) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9014"));
            }
            finally {
                this.state = 2;
            }
        }
    }

    private class TabMouseAdapter
    extends MouseAdapter {
        private TabMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.isControlDown()) {
                return;
            }
            int mx = e.getX();
            int my = e.getY();
            TabbedPaneUI ui = EngineViewFrame.this.tabbedPane.getUI();
            int index = ui.tabForCoordinate(EngineViewFrame.this.tabbedPane, mx, my);
            if (index < 0) {
                return;
            }
            EngineViewFrame.this.tabbedPane.remove(index);
            EngineViewFrame.this.tabbedPane.repaint();
        }
    }

    public class EngineTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof ProcessNode) {
                ProcessNode node = (ProcessNode)value;
                Process p = node.getProcess();
                Color c = EngineViewFrame.this.getBackgroundColor(p);
                this.setBackgroundNonSelectionColor(c);
            } else {
                this.setBackgroundNonSelectionColor(BACKGROUND);
            }
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return this;
        }
    }

    class EngineTreeListner
    extends MouseAdapter
    implements TreeWillExpandListener {
        EngineTreeListner() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() || e.getModifiers() == 8 || e.getModifiers() == 4) {
                TreePath path = EngineViewFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                EngineViewFrame.this.tree.setSelectionPath(path);
                TreeNode node = (TreeNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                JPopupMenu popup = null;
                if (node instanceof EngineNode) {
                    popup = EngineViewFrame.this.enginePopup;
                } else if (node instanceof ProcessDefinitionNode) {
                    popup = EngineViewFrame.this.procDefPopup;
                } else if (node instanceof ProcessNode) {
                    popup = EngineViewFrame.this.procPopup;
                } else {
                    return;
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath tpath = event.getPath();
            if (tpath == null) {
                return;
            }
            EngineTreeNode node = (EngineTreeNode)tpath.getLastPathComponent();
            if (node == null) {
                return;
            }
            if (node.isLeaf()) {
                return;
            }
            NodeReloadTask task = new NodeReloadTask(node, null);
            WorkflowAdminManager.runBusyTask(task);
            EngineViewFrame.this.updateEngineTree();
        }
    }
}

