/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineNode;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewController;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewFrame;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessNode;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;

public class ProcessDefinitionNode
implements EngineTreeNode {
    public static final String PDID = "pdid:";
    private EngineNode parentNode;
    private ProcDef procDef;
    private Vector children;
    private Filter defaultFilter;
    private Filter currentFilter;

    public ProcessDefinitionNode(EngineNode parent, ProcDef def) {
        this.parentNode = parent;
        this.procDef = def;
        this.children = new Vector();
        String fs = PDID + this.procDef.getID();
        this.currentFilter = this.defaultFilter = new NameFilter(fs, 1);
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return this.procDef.getID();
    }

    public void reload(Filter filter) throws Exception {
        if (filter != null) {
            if (filter instanceof GroupFilter) {
                Filter[] sub = ((GroupFilter)filter).getChild();
                sub[0] = this.defaultFilter;
            }
            this.currentFilter = filter;
        } else {
            this.currentFilter = this.defaultFilter;
        }
        EngineViewFrame frame = this.getFrame();
        EngineViewController evc = frame.getEngineViewController();
        Process[] procs = evc.getProcess(this.currentFilter);
        this.children.clear();
        for (int i = 0; i < procs.length; ++i) {
            ProcessNode child = new ProcessNode(this, procs[i]);
            this.children.add(child);
        }
    }

    public Properties getProperties(ResourceManager rm) {
        Properties prop = new Properties();
        String name = this.procDef.getName();
        if (name == null) {
            name = "";
        }
        ProcessDefinitionState state = this.procDef.getState();
        String stateString = null;
        String stateInt = null;
        if (state == null) {
            stateString = "";
            stateInt = "";
        } else {
            stateString = state.toString();
            stateInt = "" + state.toInt();
        }
        prop.put(rm.getResource("ProcessDefinitionNode.key.0"), this.procDef.getID());
        prop.put(rm.getResource("ProcessDefinitionNode.key.1"), name);
        prop.put(rm.getResource("ProcessDefinitionNode.key.2"), stateString);
        prop.put(rm.getResource("ProcessDefinitionNode.key.3"), stateInt);
        return prop;
    }

    public ProcDef getProcDef() {
        return this.procDef;
    }

    EngineViewFrame getFrame() {
        return this.parentNode.getFrame();
    }
}

