/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.common.PropertyDialog;
import jp.co.argo21.nautica.tool.wfadm.engineview.AttributeDialog;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewController;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewFrame;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessFlowView;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

public class ProcessFlowPanel
extends JPanel {
    private JToolBar toolbar;
    private EngineViewFrame frame;
    private ProcessFlowView view;
    private Process process;
    private PackageDefinition packageDefinition;

    public ProcessFlowPanel(EngineViewFrame frame, Process proc, PackageDefinition def) {
        super(new BorderLayout(), true);
        this.frame = frame;
        this.process = proc;
        this.packageDefinition = def;
        this.createFlowView();
        this.createToolBar();
    }

    String getProcessID() {
        return this.process.getID();
    }

    private void createToolBar() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.toolbar = new JToolBar(1);
        this.toolbar.setFloatable(false);
        Icon icon0 = IconManager.getIcon("property");
        JButton propButton = new JButton();
        propButton.setIcon(icon0);
        propButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.0"));
        propButton.addActionListener(new ShowPropertyAction());
        Icon icon1 = IconManager.getIcon("varlist");
        JButton varlistButton = new JButton();
        varlistButton.setIcon(icon1);
        varlistButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.1"));
        varlistButton.addActionListener(new ShowAttributeListAction());
        Icon icon2 = IconManager.getIcon("reload");
        JButton reloadButton = new JButton();
        reloadButton.setIcon(icon2);
        reloadButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.2"));
        reloadButton.addActionListener(new ReloadAction());
        Icon icon3 = IconManager.getIcon("suspend");
        JButton suspendButton = new JButton();
        suspendButton.setIcon(icon3);
        suspendButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.3"));
        suspendButton.addActionListener(new SuspendActivityAction());
        Icon icon4 = IconManager.getIcon("resume");
        JButton resumeButton = new JButton();
        resumeButton.setIcon(icon4);
        resumeButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.4"));
        resumeButton.addActionListener(new ResumeActivityAction());
        Icon icon5 = IconManager.getIcon("complete");
        JButton completeButton = new JButton();
        completeButton.setIcon(icon5);
        completeButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.5"));
        completeButton.addActionListener(new CompleteActivityAction());
        Icon icon6 = IconManager.getIcon("abort");
        JButton abortButton = new JButton();
        abortButton.setIcon(icon6);
        abortButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.6"));
        abortButton.addActionListener(new AbortProcessAction());
        this.toolbar.add(propButton);
        this.toolbar.add(varlistButton);
        this.toolbar.add(reloadButton);
        this.toolbar.addSeparator();
        this.toolbar.add(suspendButton);
        this.toolbar.add(resumeButton);
        this.toolbar.addSeparator();
        this.toolbar.add(completeButton);
        this.toolbar.add(abortButton);
        this.add((Component)this.toolbar, "West");
    }

    private void createFlowView() {
        EngineViewController evc = this.frame.getEngineViewController();
        int index = this.getProcessDefinitionIndex();
        List procs = this.packageDefinition.getProcesses();
        ProcessDefinition def = (ProcessDefinition)procs.get(index);
        this.view = new ProcessFlowView(evc, def, this.process);
        JScrollPane sp = new JScrollPane(this.view);
        this.add((Component)sp, "Center");
    }

    private Properties getProperties(ResourceManager rm, ActivityDefinition act) {
        Properties prop = new Properties();
        prop.put(rm.getResource("ActivityDefinition.key.0"), "" + act.getAffiliateBID());
        prop.put(rm.getResource("ActivityDefinition.key.1"), "" + act.getApplicationID());
        prop.put(rm.getResource("ActivityDefinition.key.2"), "" + act.getBlockID());
        prop.put(rm.getResource("ActivityDefinition.key.3"), "" + act.getDescription());
        prop.put(rm.getResource("ActivityDefinition.key.4"), "" + act.getEngineName());
        prop.put(rm.getResource("ActivityDefinition.key.5"), "" + act.getID());
        prop.put(rm.getResource("ActivityDefinition.key.6"), "" + act.getName());
        prop.put(rm.getResource("ActivityDefinition.key.7"), "" + act.getParentBID());
        prop.put(rm.getResource("ActivityDefinition.key.8"), "" + act.getPerformerID());
        prop.put(rm.getResource("ActivityDefinition.key.9"), "" + act.getSubprocessID());
        prop.put(rm.getResource("ActivityDefinition.key.10"), "" + act.getType());
        prop.put(rm.getResource("ActivityDefinition.key.11"), "" + act.getExecution());
        prop.put(rm.getResource("ActivityDefinition.key.12"), "" + act.getLimit());
        prop.put(rm.getResource("ActivityDefinition.key.13"), "" + act.getLogicalX());
        prop.put(rm.getResource("ActivityDefinition.key.14"), "" + act.getLogicalY());
        return prop;
    }

    private Properties getProperties(ResourceManager rm, Activity act) {
        Properties prop = new Properties();
        prop.put(rm.getResource("Activity.key.0"), "" + act.getActivityDefinitionID());
        prop.put(rm.getResource("Activity.key.1"), "" + act.getActivityID());
        prop.put(rm.getResource("Activity.key.2"), "" + act.getActivityState());
        prop.put(rm.getResource("Activity.key.3"), "" + act.getActorID());
        prop.put(rm.getResource("Activity.key.4"), "" + act.getBlockID());
        prop.put(rm.getResource("Activity.key.5"), "" + act.getName());
        prop.put(rm.getResource("Activity.key.6"), "" + act.getProcessID());
        prop.put(rm.getResource("Activity.key.7"), "" + act.getStarterID());
        prop.put(rm.getResource("Activity.key.8"), "" + act.getDurationLimit());
        prop.put(rm.getResource("Activity.key.9"), "" + act.getStartDate());
        prop.put(rm.getResource("Activity.key.10"), "" + act.getUpdateDate());
        return prop;
    }

    private int getProcessDefinitionIndex() {
        String pdid = this.process.getProcDefinitionID();
        int begin = pdid.lastIndexOf(45) + 1;
        int end = pdid.length();
        String indexString = pdid.substring(begin, end);
        int index = Integer.parseInt(indexString);
        return index;
    }

    private class ChangeActivityStateTask
    implements BusyTask {
        private int state = 0;
        private String pid;
        private String aid;
        private ActivityState astate;

        private ChangeActivityStateTask(String pid, String aid, ActivityState astate) {
            this.pid = pid;
            this.aid = aid;
            this.astate = astate;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            try {
                if (this.aid == null) {
                    return;
                }
                EngineViewController evc = ProcessFlowPanel.this.frame.getEngineViewController();
                evc.changeActivityState(this.pid, this.aid, this.astate);
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9029") + "(" + this.pid + "/" + this.aid + ")");
            }
            finally {
                this.aid = null;
                this.state = 2;
            }
        }
    }

    private class SetAttributeTask
    implements BusyTask {
        private int state = 0;
        private List attributes;

        public SetAttributeTask(List attributes) {
            this.attributes = attributes;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            String pid = ProcessFlowPanel.this.process.getID();
            try {
                EngineViewController evc = ProcessFlowPanel.this.frame.getEngineViewController();
                evc.setProcessAttributes(pid, this.attributes);
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9032"));
            }
            finally {
                this.state = 2;
            }
        }
    }

    private class GetAttributeTask
    implements BusyTask {
        private int state = 0;
        private List attributes;

        private GetAttributeTask() {
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            String pid = ProcessFlowPanel.this.process.getID();
            try {
                EngineViewController evc = ProcessFlowPanel.this.frame.getEngineViewController();
                this.attributes = evc.getProcessAttributes(pid, null);
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9027"));
            }
            finally {
                this.state = 2;
            }
        }

        private List getAttributes() {
            return this.attributes;
        }
    }

    private class AbortProcessAction
    implements ActionListener,
    BusyTask {
        private int state = 0;

        private AbortProcessAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessFlowPanel.this.view == null) {
                return;
            }
            if (ProcessFlowPanel.this.process == null) {
                return;
            }
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            int st = ProcessFlowPanel.this.process.getProcessState();
            if (st == ProcessState.CLOSED_COMPLETED.toInt() || st == ProcessState.CLOSED_TERMINATED.toInt() || st == ProcessState.CLOSED_ABORTED.toInt()) {
                DialogUtilities.showError(rm.getResource("E9026"));
                return;
            }
            int ret = DialogUtilities.showYesNoConfirm(rm.getResource("I9004"));
            if (ret == 1) {
                return;
            }
            WorkflowAdminManager.runBusyTask(this);
            ProcessFlowPanel.this.view.reload();
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            String pid = ProcessFlowPanel.this.process.getID();
            try {
                EngineViewController evc = ProcessFlowPanel.this.frame.getEngineViewController();
                evc.changeProcessState(pid, ProcessState.CLOSED_ABORTED);
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                DialogUtilities.showError(rm.getResource("E9027") + "(" + pid + ")");
            }
            finally {
                this.state = 2;
            }
        }
    }

    private class ResumeActivityAction
    implements ActionListener {
        private ResumeActivityAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessFlowPanel.this.view == null) {
                return;
            }
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            ActivityDefinition actdef = ProcessFlowPanel.this.view.getSelectedActivity();
            if (actdef == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            String adid = actdef.getID();
            Activity act = ProcessFlowPanel.this.view.getActivityByDefinitionID(adid);
            if (act == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            int st = act.getActivityState();
            if (st != ActivityState.OPEN_NOT_RUNNING_SUSPENDED.toInt()) {
                DialogUtilities.showError(rm.getResource("E9030"));
                return;
            }
            String pid = ProcessFlowPanel.this.process.getID();
            String aid = act.getActivityID();
            ChangeActivityStateTask task = new ChangeActivityStateTask(pid, aid, ActivityState.OPEN_RUNNING);
            WorkflowAdminManager.runBusyTask(task);
            ProcessFlowPanel.this.view.reload();
        }
    }

    private class SuspendActivityAction
    implements ActionListener {
        private SuspendActivityAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            ActivityDefinition actdef = ProcessFlowPanel.this.view.getSelectedActivity();
            if (actdef == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            String adid = actdef.getID();
            Activity act = ProcessFlowPanel.this.view.getActivityByDefinitionID(adid);
            if (act == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            int st = act.getActivityState();
            if (st != ActivityState.OPEN_RUNNING.toInt()) {
                DialogUtilities.showError(rm.getResource("E9028"));
                return;
            }
            String pid = ProcessFlowPanel.this.process.getID();
            String aid = act.getActivityID();
            ChangeActivityStateTask task = new ChangeActivityStateTask(pid, aid, ActivityState.OPEN_NOT_RUNNING_SUSPENDED);
            WorkflowAdminManager.runBusyTask(task);
            ProcessFlowPanel.this.view.reload();
        }
    }

    private class CompleteActivityAction
    implements ActionListener {
        private CompleteActivityAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            ActivityDefinition actdef = ProcessFlowPanel.this.view.getSelectedActivity();
            if (actdef == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            String adid = actdef.getID();
            Activity act = ProcessFlowPanel.this.view.getActivityByDefinitionID(adid);
            if (act == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            int st = act.getActivityState();
            if (st == ActivityState.CLOSED_COMPLETED.toInt() || st == ActivityState.CLOSED_TERMINATED.toInt() || st == ActivityState.CLOSED_ABORTED.toInt()) {
                DialogUtilities.showError(rm.getResource("E9031"));
                return;
            }
            String pid = ProcessFlowPanel.this.process.getID();
            String aid = act.getActivityID();
            ChangeActivityStateTask task = new ChangeActivityStateTask(pid, aid, ActivityState.CLOSED_COMPLETED);
            WorkflowAdminManager.runBusyTask(task);
            ProcessFlowPanel.this.view.reload();
        }
    }

    private class ReloadAction
    implements ActionListener {
        private ReloadAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessFlowPanel.this.view == null) {
                return;
            }
            ProcessFlowPanel.this.view.reload();
        }
    }

    private class ShowAttributeListAction
    implements ActionListener {
        private ShowAttributeListAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessFlowPanel.this.view == null) {
                return;
            }
            GetAttributeTask gvtask = new GetAttributeTask();
            WorkflowAdminManager.runBusyTask(gvtask);
            List list = gvtask.getAttributes();
            if (list == null || list.size() == 0) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                DialogUtilities.showInfo(rm.getResource("I9003"));
                return;
            }
            AttributeDialog dialog = new AttributeDialog();
            dialog.setAttributes(list);
            dialog.setVisible(true);
            int result = dialog.getResult();
            if (result == 2) {
                return;
            }
            List updatedList = dialog.getUpdatedAttributes();
            dialog.dispose();
            if (updatedList == null || updatedList.size() == 0) {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                DialogUtilities.showInfo(rm.getResource("I9005"));
                return;
            }
            SetAttributeTask svtask = new SetAttributeTask(updatedList);
            WorkflowAdminManager.runBusyTask(svtask);
        }
    }

    private class ShowPropertyAction
    implements ActionListener {
        private ShowPropertyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessFlowPanel.this.view == null) {
                return;
            }
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            ActivityDefinition actdef = ProcessFlowPanel.this.view.getSelectedActivity();
            if (actdef == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            Hashtable<String, Properties> props = new Hashtable<String, Properties>();
            String adid = actdef.getID();
            String adname = actdef.getName();
            List acts = ProcessFlowPanel.this.view.getActivitiesByDefinitionID(adid);
            if (acts.size() == 0) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            Iterator it = acts.iterator();
            while (it.hasNext()) {
                Activity act = (Activity)it.next();
                String aname = act.getActivityID();
                Properties actprop = ProcessFlowPanel.this.getProperties(rm, act);
                props.put(aname, actprop);
            }
            PropertyDialog.showDialog((Component)ProcessFlowPanel.this, adname, props);
        }
    }
}

