/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInformationDocument;
import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;

public class EngineInfo {
    public static final String UNSET = "(unset)";
    private String name;
    private String url;
    private String scope;
    private String user;
    private String password;
    private String adminKey;
    private Context context;
    private WorkflowServiceAccessor wsa;

    public EngineInfo() {
    }

    public EngineInfo(String name, String url, String scope, String user, String password, String adminKey) {
        this.name = name;
        this.url = url;
        this.scope = scope;
        this.user = user;
        this.password = password;
        this.adminKey = adminKey;
    }

    EngineInfo(EngineInformationDocument.EngineInformation info) {
        this.name = info.getName();
        this.url = info.getUrl();
        this.scope = info.getScope();
        this.user = info.getUser();
        this.password = info.getPassword();
        this.adminKey = info.getAdminKey();
    }

    public String getName() {
        if (this.name == null || this.name.trim().equals("")) {
            return UNSET;
        }
        return this.name;
    }

    public String getURL() {
        if (this.url == null || this.url.trim().equals("")) {
            return UNSET;
        }
        return this.url;
    }

    public String getScope() {
        if (this.scope == null || this.scope.trim().equals("")) {
            return "";
        }
        return this.scope;
    }

    public String getUser() {
        if (this.user == null || this.user.trim().equals("")) {
            return UNSET;
        }
        return this.user;
    }

    public String getPassword() {
        if (this.password == null || this.password.trim().equals("")) {
            return "";
        }
        return this.password;
    }

    public String getAdminKey() {
        if (this.adminKey == null || this.adminKey.trim().equals("")) {
            return "";
        }
        return this.adminKey;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURL(String url) {
        this.init();
        this.url = url;
    }

    public void setScope(String scope) {
        this.init();
        this.scope = scope;
    }

    public void setUser(String user) {
        this.init();
        this.user = user;
    }

    public void setPassword(String password) {
        this.init();
        this.password = password;
    }

    public void setAdminKey(String adminKey) {
        this.init();
        this.adminKey = adminKey;
    }

    public Context getContext() throws NamingException {
        if (this.context == null) {
            Properties prop = new Properties();
            prop.setProperty("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            prop.setProperty("java.naming.provider.url", this.url);
            this.context = new InitialContext(prop);
        }
        return this.context;
    }

    public WorkflowServiceAccessor getWorkflowServiceAccessor() {
        if (this.wsa == null) {
            ConnectionInfo cinfo = this.getConnectionInfo();
            Context ctxt = null;
            try {
                ctxt = this.getContext();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.wsa = new WorkflowServiceAccessor(cinfo, ctxt);
        }
        return this.wsa;
    }

    private ConnectionInfo getConnectionInfo() {
        ConnectionInfo cinfo = new ConnectionInfo(this.url, this.scope, this.user, this.password);
        return cinfo;
    }

    private void init() {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.context = null;
        this.wsa = null;
    }
}

