/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

public class EngineInfoComponent
extends DialogComponent {
    protected static final Border border = BorderFactory.createEtchedBorder();
    private JTextField nameField;
    private JTextField urlField;
    private JTextField scopeField;
    private JTextField userField;
    private JPasswordField pass1Field;
    private JPasswordField pass2Field;
    private JPasswordField key1Field;
    private JPasswordField key2Field;
    private EngineInfo engineInfo;
    private boolean isNew;

    public EngineInfoComponent() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        JPanel panel = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("EngineInfoComponent.tab.0"), panel);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 260);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("EngineInfoComponent.label.0"));
        JLabel l1 = new JLabel(rm.getResource("EngineInfoComponent.label.1"));
        JLabel l2 = new JLabel(rm.getResource("EngineInfoComponent.label.2"));
        JLabel l3 = new JLabel(rm.getResource("EngineInfoComponent.label.3"));
        JLabel l4 = new JLabel(rm.getResource("EngineInfoComponent.label.4"));
        JLabel l5 = new JLabel(rm.getResource("EngineInfoComponent.label.5"));
        JLabel l6 = new JLabel(rm.getResource("EngineInfoComponent.label.6"));
        JLabel l7 = new JLabel(rm.getResource("EngineInfoComponent.label.7"));
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(16));
        this.urlField = new JTextField("iiop://localhost:1050");
        this.urlField.setDocument(new ByteLimitedDocument(64));
        this.scopeField = new JTextField();
        this.scopeField.setDocument(new ByteLimitedDocument(32));
        this.userField = new JTextField();
        this.userField.setDocument(new ByteLimitedDocument(32));
        this.pass1Field = new JPasswordField();
        this.pass1Field.setEchoChar('*');
        this.pass1Field.setDocument(new ByteLimitedDocument(32));
        this.pass2Field = new JPasswordField();
        this.pass2Field.setEchoChar('*');
        this.pass2Field.setDocument(new ByteLimitedDocument(32));
        this.key1Field = new JPasswordField();
        this.key1Field.setEchoChar('*');
        this.key1Field.setDocument(new ByteLimitedDocument(32));
        this.key2Field = new JPasswordField();
        this.key2Field.setEchoChar('*');
        this.key2Field.setDocument(new ByteLimitedDocument(32));
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(l1, 10, 40, 100, 25));
        panel.add(this.locate(l2, 10, 70, 100, 25));
        panel.add(this.locate(l3, 10, 100, 100, 25));
        panel.add(this.locate(l4, 10, 130, 100, 25));
        panel.add(this.locate(l5, 10, 160, 100, 25));
        panel.add(this.locate(l6, 10, 190, 100, 25));
        panel.add(this.locate(l7, 10, 220, 100, 25));
        panel.add(this.locate(this.nameField, 110, 10, 190, 25));
        panel.add(this.locate(this.urlField, 110, 40, 190, 25));
        panel.add(this.locate(this.scopeField, 110, 70, 190, 25));
        panel.add(this.locate(this.userField, 110, 100, 190, 25));
        panel.add(this.locate(this.pass1Field, 110, 130, 190, 25));
        panel.add(this.locate(this.pass2Field, 110, 160, 190, 25));
        panel.add(this.locate(this.key1Field, 110, 190, 190, 25));
        panel.add(this.locate(this.key2Field, 110, 220, 190, 25));
        this.validate();
        return panel;
    }

    public void init() {
        this.nameField.setText("");
        this.urlField.setText("iiop://localhost:1050");
        this.scopeField.setText("");
        this.userField.setText("");
        this.pass1Field.setText("");
        this.pass2Field.setText("");
        this.key1Field.setText("");
        this.key2Field.setText("");
    }

    public void setEngineInfo(EngineInfo info) {
        this.init();
        if (info == null) {
            info = new EngineInfo();
            info.setURL("iiop://localhost:1050");
            this.isNew = true;
            this.nameField.setEditable(true);
        } else {
            this.isNew = false;
            this.nameField.setEditable(false);
        }
        this.engineInfo = info;
        this.nameField.setText(info.getName());
        this.urlField.setText(info.getURL());
        this.scopeField.setText(info.getScope());
        this.userField.setText(info.getUser());
        this.pass1Field.setText(info.getPassword());
        this.pass2Field.setText(info.getPassword());
        this.key1Field.setText(info.getAdminKey());
        this.key2Field.setText(info.getAdminKey());
        this.setSelectedIndex(0);
        this.repaint();
    }

    public boolean commit() {
        if (this.check()) {
            this.engineInfo.setName(this.nameField.getText());
            this.engineInfo.setURL(this.urlField.getText());
            this.engineInfo.setScope(this.scopeField.getText());
            this.engineInfo.setUser(this.userField.getText());
            this.engineInfo.setPassword(new String(this.pass1Field.getPassword()));
            this.engineInfo.setAdminKey(new String(this.key1Field.getPassword()));
            return true;
        }
        return false;
    }

    public EngineInfo getEngineInfo() {
        EngineInfo ei = this.engineInfo;
        this.engineInfo = null;
        this.init();
        return ei;
    }

    private boolean check() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        if (!this.checkEngineName(rm)) {
            return false;
        }
        if (!this.checkURL(rm)) {
            return false;
        }
        if (!this.checkScope(rm)) {
            return false;
        }
        if (!this.checkUser(rm)) {
            return false;
        }
        if (!this.checkPassword(rm)) {
            return false;
        }
        return this.checkAdminKey(rm);
    }

    private boolean checkEngineName(ResourceManager rm) {
        String s = this.nameField.getText();
        String pat = "[A-Za-z0-9]*";
        String msg = null;
        if (s == null) {
            msg = rm.getResource("E9005");
        } else if (s.trim().equals("")) {
            msg = rm.getResource("E9001");
        } else if (!Pattern.matches(pat, s)) {
            msg = rm.getResource("E9017");
        } else if (s.trim().equals("(unset)")) {
            msg = rm.getResource("E9001");
        }
        PreferenceManager pm = PreferenceManager.getInstance();
        if (this.isNew && pm.getEngineInfo(s) != null) {
            msg = rm.getResource("E9002");
        }
        if (msg != null) {
            DialogUtilities.showError(msg);
            return false;
        }
        return true;
    }

    private boolean checkURL(ResourceManager rm) {
        String s = this.urlField.getText();
        String pat = "iiop://[A-Za-z0-9_]+[\\.A-Za-z0-9_]*[A-Za-z0-9_]+:[0-9]*";
        String msg = null;
        if (s == null) {
            msg = rm.getResource("E9003");
        } else if (s.trim().equals("")) {
            msg = rm.getResource("E9003");
        } else if (s.trim().equals("(unset)")) {
            msg = rm.getResource("E9003");
        } else if (!Pattern.matches(pat, s)) {
            msg = rm.getResource("E9004");
        }
        return this.isValid(msg);
    }

    private boolean checkScope(ResourceManager rm) {
        String s = this.scopeField.getText();
        String pat = "[A-Za-z0-9_]*";
        String msg = null;
        if (s == null) {
            msg = rm.getResource("E9005");
        } else if (!Pattern.matches(pat, s)) {
            msg = rm.getResource("E9006");
        }
        return this.isValid(msg);
    }

    private boolean checkUser(ResourceManager rm) {
        String s = this.userField.getText();
        String pat = "[A-Za-z_][A-Za-z0-9_]*";
        String msg = null;
        if (s == null) {
            msg = rm.getResource("E9007");
        } else if (s.trim().equals("")) {
            msg = rm.getResource("E9007");
        } else if (s.trim().equals("(unset)")) {
            msg = rm.getResource("E9007");
        } else if (!Pattern.matches(pat, s)) {
            msg = rm.getResource("E9008");
        }
        return this.isValid(msg);
    }

    private boolean checkPassword(ResourceManager rm) {
        String s1 = new String(this.pass1Field.getPassword());
        String s2 = new String(this.pass2Field.getPassword());
        String pat = "[A-Za-z0-9_]*";
        String msg = null;
        if (s1 == null) {
            msg = rm.getResource("E9009");
        } else if (s1.trim().equals("")) {
            msg = rm.getResource("E9009");
        } else if (!Pattern.matches(pat, s1)) {
            msg = rm.getResource("E9009");
        } else if (!s1.equals(s2)) {
            msg = rm.getResource("E9010");
        }
        return this.isValid(msg);
    }

    private boolean checkAdminKey(ResourceManager rm) {
        String s1 = new String(this.key1Field.getPassword());
        String s2 = new String(this.key2Field.getPassword());
        String pat = "[A-Za-z_][A-Za-z0-9_]*";
        String msg = null;
        if (s1 == null) {
            msg = rm.getResource("E9011");
        } else if (s1.trim().equals("")) {
            msg = rm.getResource("E9011");
        } else if (!Pattern.matches(pat, s1)) {
            msg = rm.getResource("E9011");
        } else if (!s1.equals(s2)) {
            msg = rm.getResource("E9012");
        }
        return this.isValid(msg);
    }

    private boolean isValid(String msg) {
        if (msg != null) {
            DialogUtilities.showError(msg);
            return false;
        }
        return true;
    }
}

