/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfoComponent;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceDialog;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

public class PreferenceComponent
extends DialogComponent {
    private static String[] columnNames;
    protected static final Border border;
    private JTable engineInfoTable;
    private JButton addInfoButton;
    private JButton editInfoButton;
    private JButton delInfoButton;
    private EngineInfoComponent engineInfoComponent;
    static /* synthetic */ Class class$java$lang$String;

    public PreferenceComponent() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.engineInfoComponent = new EngineInfoComponent();
        JPanel panel = this.createEngineInfoPanel(rm);
        this.addTab(rm.getResource("PreferenceComponent.tab.0"), panel);
        this.validate();
    }

    private JPanel createEngineInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(border);
        Dimension size = new Dimension(500, 365);
        panel.setSize(size);
        panel.setPreferredSize(size);
        this.engineInfoTable = new JTable(new EngineInfoTableModel());
        this.engineInfoTable.setSelectionMode(0);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.engineInfoTable);
        sp.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.addInfoButton = new JButton(rm.getResource("JButton.label.add"));
        this.addInfoButton.addActionListener(new AddInfoAction());
        this.editInfoButton = new JButton(rm.getResource("JButton.label.edit"));
        this.editInfoButton.addActionListener(new EditInfoAction());
        this.delInfoButton = new JButton(rm.getResource("JButton.label.delete"));
        this.delInfoButton.addActionListener(new DeleteInfoAction());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 10, 10));
        buttonPane.add(this.addInfoButton);
        buttonPane.add(this.editInfoButton);
        buttonPane.add(this.delInfoButton);
        panel.add((Component)sp, "Center");
        panel.add((Component)buttonPane, "South");
        this.validate();
        return panel;
    }

    public void init() {
    }

    public boolean commit() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        columnNames = new String[4];
        PreferenceComponent.columnNames[0] = rm.getResource("PreferenceComponent.columnName.0");
        PreferenceComponent.columnNames[1] = rm.getResource("PreferenceComponent.columnName.1");
        PreferenceComponent.columnNames[2] = rm.getResource("PreferenceComponent.columnName.2");
        PreferenceComponent.columnNames[3] = rm.getResource("PreferenceComponent.columnName.3");
    }

    class EngineInfoTableModel
    extends AbstractTableModel {
        EngineInfoTableModel() {
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            PreferenceManager pm = PreferenceManager.getInstance();
            return pm.getEngineInfoCount();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            PreferenceManager pm = PreferenceManager.getInstance();
            EngineInfo info = pm.getEngineInfo(row);
            if (info == null) {
                return "";
            }
            if (col == 0) {
                return info.getName();
            }
            if (col == 1) {
                return info.getURL();
            }
            if (col == 2) {
                return info.getScope();
            }
            if (col == 3) {
                return info.getUser();
            }
            return "";
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = PreferenceComponent.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class DeleteInfoAction
    extends AbstractAction {
        DeleteInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            int selected = PreferenceComponent.this.engineInfoTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("W9001"));
                return;
            }
            PreferenceManager pm = PreferenceManager.getInstance();
            pm.removeEngineInfo(selected);
            PreferenceComponent.this.engineInfoTable.clearSelection();
            PreferenceComponent.this.engineInfoTable.updateUI();
        }
    }

    class EditInfoAction
    extends AbstractAction {
        EditInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EngineInfo updateinfo;
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            int selected = PreferenceComponent.this.engineInfoTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("W9001"));
                return;
            }
            PreferenceManager pm = PreferenceManager.getInstance();
            EngineInfo info = pm.getEngineInfo(selected);
            PreferenceComponent.this.engineInfoComponent.setEngineInfo(info);
            if (PreferenceDialog.showDialog(PreferenceComponent.this, PreferenceComponent.this.engineInfoComponent) && (updateinfo = PreferenceComponent.this.engineInfoComponent.getEngineInfo()) != null) {
                pm.updateEngineInfo(selected, updateinfo);
            }
            PreferenceComponent.this.engineInfoTable.updateUI();
        }
    }

    class AddInfoAction
    extends AbstractAction {
        AddInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EngineInfo info;
            PreferenceComponent.this.engineInfoComponent.setEngineInfo(null);
            if (PreferenceDialog.showDialog(PreferenceComponent.this, PreferenceComponent.this.engineInfoComponent) && (info = PreferenceComponent.this.engineInfoComponent.getEngineInfo()) != null) {
                PreferenceManager pm = PreferenceManager.getInstance();
                pm.addEngineInfo(info);
            }
            PreferenceComponent.this.engineInfoTable.updateUI();
        }
    }
}

