/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.scriptapi;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.script.Namespace;
import javax.script.ScriptContext;
import org.pnuts.scriptapi.NamespacePackage;
import org.pnuts.scriptapi.PnutsNamespace;
import org.pnuts.scriptapi.PnutsScriptEngine;
import pnuts.lang.Context;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;

public class PnutsScriptContext
implements ScriptContext {
    private Reader reader;
    protected Context context;
    Namespace globalNamespace;
    PnutsNamespace engineNamespace;
    NamespacePackage namespacePackage;

    public PnutsScriptContext() {
        this(new Context(), new PnutsNamespace(), new PnutsNamespace());
        this.initializeContext(this.context);
    }

    public PnutsScriptContext(Namespace namespace, Namespace namespace2) {
        this(new Context(), namespace, namespace2);
        this.initializeContext(this.context);
    }

    public PnutsScriptContext(ScriptContext scriptContext) {
        this(new Context(), scriptContext.getNamespace(100), scriptContext.getNamespace(200));
        this.initializeContext(this.context);
    }

    protected void initializeContext(Context context) {
        ArrayList arrayList = PnutsScriptEngine.startupModules;
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                context.usePackage((String)iterator.next());
            }
        }
    }

    public PnutsScriptContext(Context context, Namespace namespace, Namespace namespace2) {
        this.context = context;
        this.reader = new InputStreamReader(System.in);
        this.engineNamespace = namespace instanceof PnutsNamespace ? (PnutsNamespace)namespace : new PnutsNamespace(namespace);
        this.globalNamespace = namespace2;
        this.namespacePackage = new NamespacePackage();
        if (namespace2 != null) {
            this.namespacePackage.setNamespace(namespace2, 200);
        }
        if (namespace != null) {
            this.namespacePackage.setNamespace(namespace, 100);
        }
        context.setCurrentPackage((Package)this.namespacePackage);
    }

    public Context getPnutsContext() {
        return this.context;
    }

    public void setNamespace(Namespace namespace, int n) {
        if (n == 200) {
            this.globalNamespace = namespace;
        } else if (n == 100) {
            if (namespace instanceof PnutsNamespace) {
                this.engineNamespace = (PnutsNamespace)namespace;
            } else if (namespace != null) {
                this.engineNamespace = new PnutsNamespace(namespace);
            }
        } else {
            throw new IllegalArgumentException("Illegal scope value.");
        }
        if (namespace != null) {
            this.namespacePackage.setNamespace(namespace, n);
        }
    }

    public Namespace getNamespace(int n) {
        if (n == 200) {
            return this.globalNamespace;
        }
        if (n == 100) {
            return this.engineNamespace;
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    public void setAttribute(String string, Object object, int n) {
        this.getNamespace(n).put((Object)string, object);
    }

    public Object getAttribute(String string, int n) {
        return this.getNamespace(n).get(string);
    }

    public Object removeAttribute(String string, int n) {
        return this.getNamespace(n).remove(string);
    }

    public Object getAttribute(String string) {
        String string2 = string.intern();
        Namespace namespace = this.getNamespace(100);
        if (namespace instanceof PnutsNamespace) {
            NamedValue namedValue = ((PnutsNamespace)namespace).lookup(string2);
            if (namedValue != null) {
                return namedValue.get();
            }
        } else if (namespace.containsKey(string2)) {
            return namespace.get(string2);
        }
        namespace = this.getNamespace(200);
        return namespace.get(string2);
    }

    public int getAttributesScope(String string) {
        Namespace namespace = this.getNamespace(100);
        if (namespace.containsKey(string)) {
            return 100;
        }
        namespace = this.getNamespace(200);
        if (namespace.containsKey(string)) {
            return 200;
        }
        return -1;
    }

    public Writer getWriter() {
        return this.context.getWriter();
    }

    public Writer getErrorWriter() {
        return this.context.getErrorWriter();
    }

    public void setWriter(Writer writer) {
        this.context.setWriter(writer);
    }

    public void setErrorWriter(Writer writer) {
        this.context.setErrorWriter(writer);
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

