/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Field {
    private static final int AUTO_INCREMENT_FLAG = 512;
    private static final int NO_CHARSET_INFO = -1;
    private Connection connection = null;
    private String charsetName = null;
    private String databaseName = null;
    private String fullName = null;
    private String fullOriginalName = null;
    private String name;
    private String originalColumnName = null;
    private String originalTableName = null;
    private String tableName;
    private byte[] buffer;
    private int charsetIndex = 0;
    private int colDecimals;
    private int databaseNameLength = -1;
    private int databaseNameStart = -1;
    private int defaultValueLength = -1;
    private int defaultValueStart = -1;
    private int length;
    private int mysqlType = -1;
    private int nameLength;
    private int nameStart;
    private int originalColumnNameLength = -1;
    private int originalColumnNameStart = -1;
    private int originalTableNameLength = -1;
    private int originalTableNameStart = -1;
    private int precisionAdjustFactor = 0;
    private int sqlType = -1;
    private int tableNameLength;
    private int tableNameStart;
    private short colFlag;
    private String collationName = null;

    Field(String tableName, String columnName, int jdbcType, int length) {
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    Field(Connection conn, byte[] buffer, int nameStart, int nameLength, int tableNameStart, int tableNameLength, int length, int mysqlType, short colFlag, int colDecimals) throws SQLException {
        this(conn, buffer, -1, -1, tableNameStart, tableNameLength, -1, -1, nameStart, nameLength, -1, -1, length, mysqlType, colFlag, colDecimals, -1, -1, -1);
    }

    Field(Connection conn, byte[] buffer, int databaseNameStart, int databaseNameLength, int tableNameStart, int tableNameLength, int originalTableNameStart, int originalTableNameLength, int nameStart, int nameLength, int originalColumnNameStart, int originalColumnNameLength, int length, int mysqlType, short colFlag, int colDecimals, int defaultValueStart, int defaultValueLength, int charsetIndex) throws SQLException {
        this.connection = conn;
        this.buffer = buffer;
        this.nameStart = nameStart;
        this.nameLength = nameLength;
        this.tableNameStart = tableNameStart;
        this.tableNameLength = tableNameLength;
        this.length = length;
        this.colFlag = colFlag;
        this.colDecimals = colDecimals;
        this.mysqlType = mysqlType;
        this.databaseNameStart = databaseNameStart;
        this.databaseNameLength = databaseNameLength;
        this.originalTableNameStart = originalTableNameStart;
        this.originalTableNameLength = originalTableNameLength;
        this.originalColumnNameStart = originalColumnNameStart;
        this.originalColumnNameLength = originalColumnNameLength;
        this.defaultValueStart = defaultValueStart;
        this.defaultValueLength = defaultValueLength;
        if (this.mysqlType == 252) {
            this.setBlobTypeBasedOnLength();
        }
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
        if (this.sqlType == -6 && this.length == 1 && this.connection.getTinyInt1isBit()) {
            this.sqlType = -7;
        }
        this.charsetIndex = charsetIndex;
        this.charsetName = this.connection.getCharsetNameForIndex(this.charsetIndex);
        boolean isBinary = this.isBinary();
        if (this.sqlType == -4 && !isBinary) {
            this.sqlType = -1;
        } else if (this.sqlType == -3 && !isBinary) {
            this.sqlType = 12;
        }
        if (!this.isUnsigned()) {
            switch (this.mysqlType) {
                case 0: {
                    this.precisionAdjustFactor = -1;
                    break;
                }
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        } else {
            switch (this.mysqlType) {
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        }
    }

    public boolean isAutoIncrement() {
        return (this.colFlag & 0x200) > 0;
    }

    public boolean isBinary() {
        return (this.colFlag & 0x80) > 0;
    }

    public boolean isBlob() {
        return (this.colFlag & 0x10) > 0;
    }

    public String getCharacterSet() {
        return this.charsetName;
    }

    public int getMaxBytesPerCharacter() throws SQLException {
        return this.connection.getMaxBytesPerChar((String)CharsetMapping.JAVA_TO_MYSQL_CHARSET_MAP.get(this.getCharacterSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getCollation() throws SQLException {
        if (this.collationName == null && this.connection != null && this.connection.versionMeetsMinimum(4, 1, 0)) {
            DatabaseMetaData dbmd = this.connection.getMetaData();
            String quotedIdStr = dbmd.getIdentifierQuoteString();
            if (" ".equals(quotedIdStr)) {
                quotedIdStr = "";
            }
            String csCatalogName = this.getDatabaseName();
            String csTableName = this.getOriginalTableName();
            String csColumnName = this.getOriginalName();
            if (csCatalogName != null && csCatalogName.length() != 0 && csTableName != null && csTableName.length() != 0 && csColumnName != null && csColumnName.length() != 0) {
                Statement collationStmt;
                block9: {
                    StringBuffer queryBuf = new StringBuffer(csCatalogName.length() + csTableName.length() + 28);
                    queryBuf.append("SHOW FULL COLUMNS FROM ");
                    queryBuf.append(quotedIdStr);
                    queryBuf.append(csCatalogName);
                    queryBuf.append(quotedIdStr);
                    queryBuf.append(".");
                    queryBuf.append(quotedIdStr);
                    queryBuf.append(csTableName);
                    queryBuf.append(quotedIdStr);
                    collationStmt = null;
                    ResultSet collationRs = null;
                    try {
                        collationStmt = this.connection.createStatement();
                        collationRs = collationStmt.executeQuery(queryBuf.toString());
                        while (collationRs.next()) {
                            if (!csColumnName.equals(collationRs.getString("Field"))) continue;
                            this.collationName = collationRs.getString("Collation");
                            break;
                        }
                        Object var10_9 = null;
                        if (collationRs == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        if (collationRs != null) {
                            collationRs.close();
                            collationRs = null;
                        }
                        if (collationStmt != null) {
                            collationStmt.close();
                            collationStmt = null;
                        }
                        throw throwable;
                    }
                    collationRs.close();
                    collationRs = null;
                }
                if (collationStmt != null) {
                    collationStmt.close();
                    collationStmt = null;
                }
            }
        }
        return this.collationName;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
        this.charsetName = this.connection.getEncoding();
    }

    public String getDatabaseName() {
        if (this.databaseName == null && this.databaseNameStart != -1 && this.databaseNameLength != -1) {
            this.databaseName = this.getStringFromBytes(this.databaseNameStart, this.databaseNameLength);
        }
        return this.databaseName;
    }

    public String getFullName() {
        if (this.fullName == null) {
            StringBuffer fullNameBuf = new StringBuffer(this.getTableName().length() + 1 + this.getName().length());
            fullNameBuf.append(this.tableName);
            fullNameBuf.append('.');
            fullNameBuf.append(this.name);
            this.fullName = fullNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullName;
    }

    public String getFullOriginalName() {
        this.getOriginalName();
        if (this.originalColumnName == null) {
            return null;
        }
        if (this.fullName == null) {
            StringBuffer fullOriginalNameBuf = new StringBuffer(this.getOriginalTableName().length() + 1 + this.getOriginalName().length());
            fullOriginalNameBuf.append(this.originalTableName);
            fullOriginalNameBuf.append('.');
            fullOriginalNameBuf.append(this.originalColumnName);
            this.fullOriginalName = fullOriginalNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullOriginalName;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isMultipleKey() {
        return (this.colFlag & 8) > 0;
    }

    public int getMysqlType() {
        return this.mysqlType;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getStringFromBytes(this.nameStart, this.nameLength);
        }
        return this.name;
    }

    public String getOriginalName() {
        if (this.originalColumnName == null && this.originalColumnNameStart != -1 && this.originalColumnNameLength != -1) {
            this.originalColumnName = this.getStringFromBytes(this.originalColumnNameStart, this.originalColumnNameLength);
        }
        return this.originalColumnName;
    }

    public String getOriginalTableName() {
        if (this.originalTableName == null && this.originalTableNameStart != -1 && this.originalTableNameLength != -1) {
            this.originalTableName = this.getStringFromBytes(this.originalTableNameStart, this.originalTableNameLength);
        }
        return this.originalTableName;
    }

    public int getPrecisionAdjustFactor() {
        return this.precisionAdjustFactor;
    }

    public boolean isPrimaryKey() {
        return (this.colFlag & 2) > 0;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public String getTable() {
        return this.getTableName();
    }

    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = this.getStringFromBytes(this.tableNameStart, this.tableNameLength);
        }
        return this.tableName;
    }

    public boolean isUniqueKey() {
        return (this.colFlag & 4) > 0;
    }

    public boolean isUnsigned() {
        return (this.colFlag & 0x20) > 0;
    }

    public boolean isZeroFill() {
        return (this.colFlag & 0x40) > 0;
    }

    public String toString() {
        return this.getDatabaseName() + " . " + this.getTableName() + "(" + this.getOriginalTableName() + ") . " + this.getName() + "(" + this.getOriginalName() + ")" + ", Mysql type: " + this.getMysqlType();
    }

    int getDecimals() {
        return this.colDecimals;
    }

    boolean isNotNull() {
        return (this.colFlag & 1) > 0;
    }

    boolean isOpaqueBinary() throws SQLException {
        if (this.charsetIndex == 63 && this.isBinary()) {
            return true;
        }
        return this.connection.versionMeetsMinimum(4, 1, 0) && "binary".equalsIgnoreCase(this.getCharacterSet());
    }

    boolean isReadOnly() throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            String orgColumnName = this.getOriginalName();
            String orgTableName = this.getOriginalTableName();
            return orgColumnName == null || orgColumnName.length() <= 0 || orgTableName == null || orgTableName.length() <= 0;
        }
        return false;
    }

    void setMysqlType(int type) {
        this.mysqlType = type;
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
    }

    private String getStringFromBytes(int stringStart, int stringLength) {
        if (stringStart == -1 || stringLength == -1) {
            return null;
        }
        String stringVal = null;
        if (this.connection != null) {
            if (this.connection.getUseUnicode()) {
                String encoding = this.connection.getEncoding();
                if (encoding != null) {
                    SingleByteCharsetConverter converter = null;
                    if (this.connection != null) {
                        converter = this.connection.getCharsetConverter(encoding);
                    }
                    if (converter != null) {
                        stringVal = converter.toString(this.buffer, stringStart, stringLength);
                    } else {
                        byte[] stringBytes = new byte[stringLength];
                        int endIndex = stringStart + stringLength;
                        int pos = 0;
                        for (int i = stringStart; i < endIndex; ++i) {
                            stringBytes[pos++] = this.buffer[i];
                        }
                        try {
                            stringVal = new String(stringBytes, encoding);
                        }
                        catch (UnsupportedEncodingException ue) {
                            throw new RuntimeException(Messages.getString("Field.12") + encoding + Messages.getString("Field.13"));
                        }
                    }
                } else {
                    stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
                }
            } else {
                stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
            }
        } else {
            stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
        }
        return stringVal;
    }

    private void setBlobTypeBasedOnLength() {
        if ((long)this.length == 255L) {
            this.mysqlType = 249;
        } else if ((long)this.length == 65535L) {
            this.mysqlType = 252;
        } else if ((long)this.length == 0xFFFFFFL) {
            this.mysqlType = 250;
        } else if ((long)this.length == 0xFFFFFFFFL) {
            this.mysqlType = 251;
        }
    }
}

