/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.util.LRUCache;
import java.sql.BatchUpdateException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Statement
implements java.sql.Statement {
    protected static int statementCounter = 1;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected Connection connection = null;
    protected LRUCache resultSetMetadataCache;
    protected List batchedArgs;
    protected List openResults = new ArrayList();
    protected ProfileEventSink eventSink = null;
    protected ResultSet results = null;
    protected SQLWarning warningChain = null;
    protected SingleByteCharsetConverter charConverter = null;
    protected String charEncoding = null;
    protected String currentCatalog = null;
    protected Throwable pointOfOrigin;
    protected boolean doEscapeProcessing = true;
    protected boolean isClosed = false;
    protected boolean maxRowsChanged = false;
    protected boolean pedantic = false;
    protected boolean profileSQL = false;
    protected boolean useUsageAdvisor = false;
    protected int maxFieldSize = MysqlIO.getMaxBuf();
    protected int maxRows = -1;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected int statementId;
    protected int timeout = 0;
    protected long lastInsertId = -1L;
    protected long updateCount = -1L;
    private int fetchSize = 0;

    public Statement(Connection c, String catalog) throws SQLException {
        int maxRowsConn;
        if (c == null || c.isClosed()) {
            throw new SQLException(Messages.getString("Statement.0"), "08003");
        }
        this.connection = c;
        this.currentCatalog = catalog;
        this.pedantic = this.connection.getPedantic();
        this.connection.registerStatement(this);
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
        }
        if (this.connection.getUseUnicode()) {
            this.charEncoding = this.connection.getEncoding();
            this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
        }
        if (this.connection.getProfileSql() || this.connection.getUseUsageAdvisor()) {
            this.statementId = statementCounter++;
            this.pointOfOrigin = new Throwable();
            this.profileSQL = this.connection.getProfileSql();
            this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
            this.eventSink = ProfileEventSink.getInstance(this.connection);
        }
        if ((maxRowsConn = this.connection.getMaxRows()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException(Messages.getString("Statement.5"), "S1009");
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw new SQLException(Messages.getString("Statement.7"), "S1009");
        }
        this.fetchSize = rows;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized java.sql.ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedKeysInternal();
    }

    protected synchronized java.sql.ResultSet getGeneratedKeysInternal() throws SQLException {
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        ArrayList<byte[][]> rowSet = new ArrayList<byte[][]>();
        long beginAt = this.getLastInsertID();
        int numKeys = this.getUpdateCount();
        String serverInfo = this.results.getServerInfo();
        if (numKeys > 0 && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
            numKeys = this.getRecordCountFromInfo(serverInfo);
        }
        if (beginAt > 0L && numKeys > 0) {
            for (int i = 0; i < numKeys; ++i) {
                byte[][] row = new byte[][]{Long.toString(beginAt++).getBytes()};
                rowSet.add(row);
            }
        }
        return new ResultSet(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection, this);
    }

    public synchronized long getLastInsertID() {
        return this.lastInsertId;
    }

    public synchronized long getLongUpdateCount() {
        if (this.results == null) {
            return -1L;
        }
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.updateCount;
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        int maxBuf;
        if (max < 0) {
            throw new SQLException(Messages.getString("Statement.11"), "S1009");
        }
        int n = maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.getMaxBuf();
        if (max > maxBuf) {
            throw new SQLException(Messages.getString("Statement.13", new Object[]{new Long(maxBuf)}), "S1009");
        }
        this.maxFieldSize = max;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        if (max > 50000000 || max < 0) {
            throw new SQLException(Messages.getString("Statement.15") + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            this.maxRowsChanged = false;
        } else {
            this.connection.maxRowsChanged(this);
        }
    }

    public synchronized int getMaxRows() throws SQLException {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public synchronized boolean getMoreResults(int current) throws SQLException {
        ResultSet nextResultSet = this.results.getNextResultSet();
        switch (current) {
            case 1: {
                if (this.results == null) break;
                this.results.close();
                break;
            }
            case 3: {
                if (this.results != null) {
                    this.results.close();
                }
                this.closeAllOpenResults();
                break;
            }
            case 2: {
                this.openResults.add(this.results);
                break;
            }
            default: {
                throw new SQLException(Messages.getString("Statement.19"), "S1009");
            }
        }
        this.results = nextResultSet;
        if (this.results == null) {
            this.updateCount = -1L;
            this.lastInsertId = -1L;
        } else if (this.results.reallyResult()) {
            this.updateCount = -1L;
            this.lastInsertId = -1L;
        } else {
            this.updateCount = this.results.getUpdateCount();
            this.lastInsertId = this.results.getUpdateID();
        }
        return this.results != null && this.results.reallyResult();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException(Messages.getString("Statement.21"), "S1009");
        }
        this.timeout = seconds;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public synchronized int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
        return truncatedUpdateCount;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            SQLWarning pendingWarningsFromServer = SQLError.convertShowWarningsToSQLWarnings(this.connection);
            if (this.warningChain != null) {
                this.warningChain.setNextWarning(pendingWarningsFromServer);
            } else {
                this.warningChain = pendingWarningsFromServer;
            }
            return this.warningChain;
        }
        return this.warningChain;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    public void cancel() throws SQLException {
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public void close() throws SQLException {
        this.realClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String sql) throws SQLException {
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        char firstNonWsChar = StringUtils.firstNonWsCharUc(sql);
        boolean isSelect = true;
        if (firstNonWsChar != 'S') {
            isSelect = false;
            if (this.connection.isReadOnly()) {
                throw new SQLException(Messages.getString("Statement.27") + Messages.getString("Statement.28"), "S1009");
            }
        }
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql);
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        if (this.results != null) {
            this.results.realClose(false);
        }
        CachedResultSetMetaData cachedMetaData = null;
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.getCacheResultSetMetadata()) {
                cachedMetaData = this.getCachedMetaData(sql);
            }
            if (this.connection.useMaxRows()) {
                int rowLimit = -1;
                if (isSelect) {
                    if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                        rowLimit = this.maxRows;
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    } else {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    }
                } else {
                    this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                }
                rs = this.connection.execSQL(this, sql, rowLimit, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), isSelect, this.currentCatalog, cachedMetaData == null);
            } else {
                rs = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), isSelect, this.currentCatalog, cachedMetaData == null);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = rs.getUpdateID();
        if (rs != null) {
            this.results = rs;
            rs.setFirstCharOfQuery(firstNonWsChar);
            if (rs.reallyResult()) {
                if (cachedMetaData != null) {
                    this.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                } else if (this.connection.getCacheResultSetMetadata()) {
                    this.initializeResultsMetadataFromCache(sql, null, this.results);
                }
            }
        }
        return rs != null && rs.reallyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys == 1) {
            this.checkClosed();
            Object object = this.connection.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql);
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices != null && generatedKeyIndices.length > 0) {
            this.checkClosed();
            Object object = this.connection.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql);
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames != null && generatedKeyNames.length > 0) {
            this.checkClosed();
            Object object = this.connection.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql);
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("Statement.34") + Messages.getString("Statement.35"), "S1009");
        }
        if (this.results != null) {
            this.results.realClose(false);
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                for (int i = 0; i < nbrCommands; ++i) {
                    updateCounts[i] = -3;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                    try {
                        updateCounts[commandIndex] = this.executeUpdate((String)this.batchedArgs.get(commandIndex));
                        continue;
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = -3;
                        if (this.connection.getContinueBatchOnError()) {
                            sqlEx = ex;
                            continue;
                        }
                        int[] newUpdateCounts = new int[commandIndex];
                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                    }
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            int[] nArray = updateCounts != null ? updateCounts : new int[]{};
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql);
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql);
        this.checkForDml(sql, firstStatementChar);
        if (this.results != null) {
            this.results.realClose(false);
        }
        CachedResultSetMetaData cachedMetaData = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.getCacheResultSetMetadata()) {
                cachedMetaData = this.getCachedMetaData(sql);
            }
            if (this.connection.useMaxRows()) {
                if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                    this.results = this.connection.execSQL(this, sql, this.maxRows, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog, cachedMetaData == null);
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    } else {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    }
                    this.results = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog, cachedMetaData == null);
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog, cachedMetaData == null);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        if (cachedMetaData != null) {
            this.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
        } else if (this.connection.getCacheResultSetMetadata()) {
            this.initializeResultsMetadataFromCache(sql, null, this.results);
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate(String sql) throws SQLException {
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("Statement.42") + Messages.getString("Statement.43"), "S1009");
        }
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
            throw new SQLException(Messages.getString("Statement.46"), "01S03");
        }
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql);
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql);
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        if (this.results != null) {
            this.results.realClose(false);
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
            }
            rs = this.connection.execSQL(this, sql, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.results = rs;
        rs.setFirstCharOfQuery(firstStatementChar);
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys == 1) {
            this.checkClosed();
            Object object = this.connection.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql);
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices != null && generatedKeyIndices.length > 0) {
            this.checkClosed();
            Object object = this.connection.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql);
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames != null && generatedKeyNames.length > 0) {
            this.checkClosed();
            Object object = this.connection.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql);
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    protected CachedResultSetMetaData getCachedMetaData(String sql) {
        if (this.resultSetMetadataCache != null) {
            return (CachedResultSetMetaData)this.resultSetMetadataCache.get(sql);
        }
        return null;
    }

    protected int getId() {
        return this.statementId;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(Messages.getString("Statement.49"), "08003");
        }
    }

    protected void checkForDml(String sql, char firstStatementChar) throws SQLException {
        if ((firstStatementChar == 'I' || firstStatementChar == 'U' || firstStatementChar == 'D' || firstStatementChar == 'A' || firstStatementChar == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(sql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(sql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(sql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "ALTER"))) {
            throw new SQLException(Messages.getString("Statement.57"), "S1009");
        }
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw new SQLException(Messages.getString("Statement.59"), "S1009");
        }
        if (sql.length() == 0) {
            throw new SQLException(Messages.getString("Statement.61"), "S1009");
        }
    }

    protected void closeAllOpenResults() {
        if (this.openResults != null) {
            Iterator iter = this.openResults.iterator();
            while (iter.hasNext()) {
                ResultSet element = (ResultSet)iter.next();
                try {
                    element.realClose(false);
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
        }
    }

    protected boolean createStreamingResultSet() {
        return this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeResultsMetadataFromCache(String sql, CachedResultSetMetaData cachedMetaData, ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        synchronized (resultSet2) {
            if (cachedMetaData == null) {
                cachedMetaData = new CachedResultSetMetaData();
                cachedMetaData.fields = this.results.fields;
                resultSet.buildIndexMapping();
                cachedMetaData.columnNameToIndex = resultSet.columnNameToIndex;
                cachedMetaData.fullColumnNameToIndex = resultSet.fullColumnNameToIndex;
                cachedMetaData.metadata = resultSet.getMetaData();
                if (this.resultSetMetadataCache == null) {
                    this.resultSetMetadataCache = new LRUCache(this.connection.getMetadataCacheSize());
                }
                this.resultSetMetadataCache.put(sql, cachedMetaData);
            } else {
                resultSet.fields = cachedMetaData.fields;
                resultSet.columnNameToIndex = cachedMetaData.columnNameToIndex;
                resultSet.fullColumnNameToIndex = cachedMetaData.fullColumnNameToIndex;
                resultSet.hasBuiltIndexMapping = true;
            }
        }
    }

    protected void realClose(boolean calledExplicitly) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.useUsageAdvisor && !calledExplicitly) {
            String message = Messages.getString("Statement.63") + Messages.getString("Statement.64");
            this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.currentCatalog, this.connection.getId(), this.getId(), -1, System.currentTimeMillis(), 0, null, this.pointOfOrigin, message));
        }
        if (this.results != null) {
            try {
                this.results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            if (this.maxRowsChanged) {
                this.connection.unsetMaxRows(this);
            }
            this.connection.unregisterStatement(this);
        }
        this.results = null;
        this.connection = null;
        this.warningChain = null;
        this.closeAllOpenResults();
        this.openResults = null;
        this.isClosed = true;
    }

    synchronized void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    synchronized void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    private int getRecordCountFromInfo(String serverInfo) {
        int i;
        StringBuffer recordsBuf = new StringBuffer();
        int recordsCount = 0;
        int duplicatesCount = 0;
        char c = '\u0000';
        int length = serverInfo.length();
        for (i = 0; i < length && !Character.isDigit(c = serverInfo.charAt(i)); ++i) {
        }
        recordsBuf.append(c);
        ++i;
        while (i < length && Character.isDigit(c = serverInfo.charAt(i))) {
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Integer.parseInt(recordsBuf.toString());
        StringBuffer duplicatesBuf = new StringBuffer();
        while (i < length && !Character.isDigit(c = serverInfo.charAt(i))) {
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        while (i < length && Character.isDigit(c = serverInfo.charAt(i))) {
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Integer.parseInt(duplicatesBuf.toString());
        return recordsCount - duplicatesCount;
    }

    class CachedResultSetMetaData {
        Map columnNameToIndex = null;
        Map fullColumnNameToIndex = null;
        ResultSetMetaData metadata;
        Field[] fields;

        CachedResultSetMetaData() {
        }
    }
}

