/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import org.pnuts.jdbc.ColumnMap;

public class ResultSetReader {
    ResultSet rset;
    private String[] columnNames;

    public ResultSetReader(ResultSet rset) throws SQLException {
        this.rset = rset;
        ResultSetMetaData meta = rset.getMetaData();
        int columnCount = meta.getColumnCount();
        this.columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String name = meta.getColumnName(i + 1);
            this.columnNames[i] = name = name.toLowerCase();
        }
    }

    public ColumnMap next() throws SQLException {
        boolean hasNext = this.rset.next();
        if (hasNext) {
            Object[] values = new Object[this.columnNames.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.rset.getObject(this.columnNames[i]);
            }
            return new ColumnMap(this.columnNames, values);
        }
        return null;
    }

    public void addTo(Collection collection) throws SQLException {
        ColumnMap cm;
        while ((cm = this.next()) != null) {
            collection.add(cm);
        }
    }
}

