/*
 * Decompiled with CFR 0.152.
 */
package pnuts.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;

public class ImageCanvas
extends Canvas {
    Image image;
    int width = -1;
    int height = -1;
    double rate_x = 1.0;
    double rate_y = 1.0;
    private boolean completed = false;
    private boolean error = false;
    private int top;
    private int bottom;

    public ImageCanvas(Image image) {
        this(image, -1, -1);
    }

    public ImageCanvas(URL url) {
        this(url, -1, -1);
    }

    public ImageCanvas(String file) throws FileNotFoundException {
        this(file, -1, -1);
    }

    public ImageCanvas(Image image, double rate_x, double rate_y) {
        this(image);
        this.rate_x = rate_x;
        this.rate_y = rate_y;
    }

    public ImageCanvas(URL url, double rate_x, double rate_y) {
        this(url);
        this.rate_x = rate_x;
        this.rate_y = rate_y;
    }

    public ImageCanvas(String file, double rate_x, double rate_y) throws FileNotFoundException {
        this(file);
        this.rate_x = rate_x;
        this.rate_y = rate_y;
    }

    public ImageCanvas(Image image, int width, int height) {
        this.image = image;
        this.width = width;
        this.height = height;
        this.completed = image.getWidth(this) >= 0 && image.getHeight(this) >= 0;
    }

    public ImageCanvas(URL url, int width, int height) {
        this.image = Toolkit.getDefaultToolkit().getImage(url);
        this.width = width;
        this.height = height;
        this.completed = this.image.getWidth(this) >= 0 && this.image.getHeight(this) >= 0;
    }

    public ImageCanvas(String file, int width, int height) throws FileNotFoundException {
        if (!new File(file).exists()) {
            throw new FileNotFoundException(file);
        }
        this.image = Toolkit.getDefaultToolkit().getImage(file);
        this.width = width;
        this.height = height;
        this.completed = this.image.getWidth(this) >= 0 && this.image.getHeight(this) >= 0;
    }

    public synchronized Dimension getPreferredSize() {
        if (this.width >= 0 && this.height >= 0) {
            return new Dimension(this.width, this.height);
        }
        int w = this.image.getWidth(this);
        int h = this.image.getHeight(this);
        while (!(this.error || w >= 0 && h >= 0)) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            w = this.image.getWidth(this);
            h = this.image.getHeight(this);
        }
        if (this.rate_x == 1.0 && this.rate_y == 1.0) {
            return new Dimension(w, h);
        }
        w = (int)Math.round((double)w * this.rate_x);
        h = (int)Math.round((double)h * this.rate_y);
        return new Dimension(w, h);
    }

    public synchronized void sync() {
        while (!this.completed && !this.error) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x40) != 0) {
            this.error = true;
            return true;
        }
        boolean b = super.imageUpdate(img, flags, x, y, w, h);
        this.bottom = y;
        if (!b) {
            this.completed = true;
        }
        this.notifyAll();
        return b;
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (!this.completed) {
            g.setClip(0, this.top, w, this.bottom - this.top);
        } else {
            g.setClip(0, 0, w, h);
        }
        if (this.width >= 0 && this.height >= 0) {
            g.drawImage(this.image, 0, 0, this.width, this.height, this);
        } else if (this.rate_x == 1.0 && this.rate_y == 1.0) {
            g.drawImage(this.image, 0, 0, this);
        } else {
            w = this.getPreferredSize().width;
            h = this.getPreferredSize().height;
            g.drawImage(this.image, 0, 0, w, h, this);
        }
        this.top = this.bottom;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public boolean isError() {
        return this.error;
    }
}

