/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.pnuts.lib.PathHelper;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

class reader
extends PnutsFunction {
    public reader() {
        super("reader");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2;
    }

    static Reader getReader(Object input, Context context) throws IOException {
        if (input instanceof Reader) {
            return (Reader)input;
        }
        if (input instanceof InputStream) {
            return new BufferedReader(new InputStreamReader((InputStream)input));
        }
        if (input instanceof File) {
            return new BufferedReader(new InputStreamReader(new FileInputStream((File)input)));
        }
        if (input instanceof String) {
            File file = PathHelper.getFile((String)input, context);
            return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        if (input instanceof URL) {
            int loc;
            int semi;
            URL url = (URL)input;
            URLConnection con = url.openConnection();
            String contentType = con.getContentType();
            String encoding = null;
            if (contentType != null && (semi = contentType.indexOf(59)) >= 0 && (loc = contentType.indexOf("charset=", semi)) >= 0) {
                encoding = contentType.substring(loc + 8).replace('\"', ' ').trim();
            }
            InputStream in = con.getInputStream();
            if (encoding != null) {
                return new BufferedReader(new InputStreamReader(in, encoding));
            }
            return new BufferedReader(new InputStreamReader(in));
        }
        throw new IllegalArgumentException(String.valueOf(input));
    }

    static Reader getReader(Object input, String encoding, Context context) throws IOException {
        if (input instanceof Reader) {
            return (Reader)input;
        }
        if (input instanceof InputStream) {
            return new BufferedReader(new InputStreamReader((InputStream)input, encoding));
        }
        if (input instanceof File) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)input), encoding));
        }
        if (input instanceof String) {
            File file = PathHelper.getFile((String)input, context);
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        }
        if (input instanceof URL) {
            return new BufferedReader(new InputStreamReader(((URL)input).openStream(), encoding));
        }
        throw new IllegalArgumentException(String.valueOf(input));
    }

    protected Object exec(Object[] args, Context context) {
        int nargs = args.length;
        try {
            if (nargs == 1) {
                return reader.getReader(args[0], context);
            }
            if (nargs == 2) {
                return reader.getReader(args[0], (String)args[1], context);
            }
            this.undefined(args, context);
            return null;
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public String toString() {
        return "function reader((Reader|InputStream|URL|String|File) {, encoding } )";
    }
}

