/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.pnuts.util.LRUCache;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;

class LRUcache
extends PnutsFunction {
    public LRUcache() {
        super("LRUcache");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2;
    }

    public Object exec(Object[] args, Context context) {
        int nargs = args.length;
        if (nargs == 1) {
            int max2 = (Integer)args[0];
            return new FixedSizedCache(max2, null, context);
        }
        if (nargs == 2) {
            int max3 = (Integer)args[0];
            return new FixedSizedCache(max3, (PnutsFunction)args[1], context);
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function LRUcache(size { , function(key) })";
    }

    static class FixedSizedCache
    extends LRUCache
    implements Map {
        PnutsFunction f;
        Context context;
        static Object NULL_OBJECT = new Object();

        FixedSizedCache(int max2, PnutsFunction f, Context c) {
            super(max2);
            this.f = f;
            this.context = c;
        }

        public synchronized Object get(Object key) {
            Object value;
            if (key == null) {
                key = NULL_OBJECT;
            }
            if ((value = super.get(key)) == null && this.f != null) {
                value = this.f.call(new Object[]{key}, this.context);
                super.put(key, value);
            }
            return value;
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

