/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import pnuts.lang.Context;
import pnuts.lang.Implementation;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsImpl;

class MapPackage
extends Package {
    private Map map;
    private static PnutsImpl pureImpl = new PnutsImpl();

    public MapPackage(Map map2) {
        this.map = map2;
    }

    public static void defineMap(Map map2, String def, Context context) {
        Context ctx = new Context(context);
        ctx.setImplementation((Implementation)pureImpl);
        ctx.setCurrentPackage((Package)new MapPackage(map2));
        Pnuts.eval((String)def, (Context)ctx);
    }

    public Object get(String symbol, Context context) {
        return this.map.get(symbol);
    }

    public void set(String symbol, Object value, Context context) {
        this.map.put(symbol, value);
    }

    public boolean defined(String name, Context context) {
        return this.map.containsKey(name);
    }

    public Enumeration keys() {
        return Collections.enumeration(this.map.keySet());
    }

    public Enumeration values() {
        return Collections.enumeration(this.map.values());
    }

    public int size() {
        return this.map.size();
    }

    public NamedValue lookup(final String symbol, Context context) {
        final Object value = this.map.get(symbol);
        if (value != null) {
            return new NamedValue(){

                public String getName() {
                    return symbol;
                }

                public Object get() {
                    return value;
                }

                public void set(Object newValue) {
                    MapPackage.this.map.put(symbol, newValue);
                }
            };
        }
        return null;
    }

    public static class Function
    extends PnutsFunction {
        protected Object exec(Object[] args, Context context) {
            if (args.length != 2) {
                this.undefined(args, context);
                return null;
            }
            Map m = (Map)args[0];
            String def = (String)args[1];
            MapPackage.defineMap(m, def, context);
            return m;
        }
    }
}

