/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;
import pnuts.lib.CalendarCache;
import pnuts.lib.DateTimeFormat;

class date
extends PnutsFunction {
    static final String TIMEZONE = "pnuts$lib$timezone".intern();
    static final String CALENDAR = "pnuts$lib$calendar".intern();
    static final String CALENDAR_POOL = "pnuts$lib$calendar_pool".intern();

    public date() {
        super("date");
    }

    public boolean defined(int nargs) {
        return nargs < 4 || nargs == 6;
    }

    static TimeZone getTimeZone(Context context) {
        TimeZone zone = (TimeZone)context.get(TIMEZONE);
        if (zone == null) {
            zone = TimeZone.getDefault();
            context.set(TIMEZONE, (Object)zone);
        }
        return zone;
    }

    static void setTimeZone(Context context, TimeZone zone) {
        CalendarCache cc = (CalendarCache)context.get(CALENDAR_POOL);
        if (cc != null) {
            cc.reset();
        }
        context.set(TIMEZONE, (Object)zone);
        context.set(CALENDAR, null);
        DateTimeFormat.reset(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Calendar getCalendar(Context context) {
        Context context2 = context;
        synchronized (context2) {
            Calendar c = (Calendar)context.get(CALENDAR);
            if (c == null) {
                c = Calendar.getInstance(date.getTimeZone(context));
                context.set(CALENDAR, (Object)c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Calendar getCalendar(Date date2, Context context) {
        CalendarCache cc;
        Context context2 = context;
        synchronized (context2) {
            cc = (CalendarCache)context.get(CALENDAR_POOL);
            if (cc == null) {
                cc = new CalendarCache(context);
                context.set(CALENDAR_POOL, (Object)cc);
            }
        }
        return cc.get(date2);
    }

    protected Object exec(Object[] args, Context context) {
        int nargs = args.length;
        switch (nargs) {
            case 0: {
                return new Date();
            }
            case 1: {
                Object arg = args[0];
                if (arg instanceof Date) {
                    return arg;
                }
                if (arg instanceof Number) {
                    return new Date(((Number)arg).longValue());
                }
                if (arg instanceof String) {
                    return DateTimeFormat.parse((String)arg, context);
                }
                throw new IllegalArgumentException(String.valueOf(arg));
            }
            case 2: {
                Object arg0 = args[0];
                Object arg1 = args[1];
                if (arg0 instanceof String && arg1 instanceof String) {
                    return DateTimeFormat.parse((String)arg0, (String)arg1, context);
                }
                throw new IllegalArgumentException(arg0 + ", " + arg1);
            }
            case 3: {
                int year = ((Number)args[0]).intValue();
                int month = ((Number)args[1]).intValue();
                int day = ((Number)args[2]).intValue();
                Date d = new Date(0L);
                Calendar c = date.getCalendar(d, context);
                c.set(year, month - 1, day, 0, 0, 0);
                c.set(14, 0);
                d.setTime(c.getTimeInMillis());
                return d;
            }
            case 6: {
                int year = ((Number)args[0]).intValue();
                int month = ((Number)args[1]).intValue();
                int day = ((Number)args[2]).intValue();
                int hour = ((Number)args[3]).intValue();
                int minute = ((Number)args[4]).intValue();
                int second = ((Number)args[5]).intValue();
                Date d = new Date(0L);
                Calendar c = date.getCalendar(d, context);
                c.set(year, month - 1, day, hour, minute, second);
                c.set(14, 0);
                d.setTime(c.getTimeInMillis());
                return d;
            }
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function date(),(expr),(expr,pattern),(year,month,day),(year,month,day,hour,minute,second)";
    }
}

