/*
 * Decompiled with CFR 0.152.
 */
package pnuts.nio;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Collection;
import org.pnuts.io.URLHelper;
import org.pnuts.lib.PathHelper;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.nio.CallbackLineHandler;
import pnuts.nio.CharBufferLineReader;
import pnuts.nio.CollectionLineHandler;
import pnuts.text.AbstractLineReader;
import pnuts.text.LineHandler;
import pnuts.text.LineReader;

class scanLines
extends PnutsFunction {
    public scanLines() {
        super("scanLines");
    }

    public boolean defined(int narg) {
        return narg == 2 || narg == 3;
    }

    static AbstractLineReader getLineReader(Object arg, LineHandler handler, Context context) throws IOException {
        AbstractLineReader lineReader;
        if (arg instanceof InputStream) {
            lineReader = new LineReader(new InputStreamReader((InputStream)arg));
            lineReader.setLineHandler(handler);
        } else if (arg instanceof Reader) {
            lineReader = new LineReader((Reader)arg);
            lineReader.setLineHandler(handler);
        } else if (arg instanceof File) {
            lineReader = new LineReader(new FileReader((File)arg));
            lineReader.setLineHandler(handler);
        } else if (arg instanceof String) {
            lineReader = new LineReader(new FileReader(PathHelper.getFile((String)arg, context)));
            lineReader.setLineHandler(handler);
        } else if (arg instanceof URL) {
            lineReader = new LineReader(URLHelper.getReader((URL)arg));
            lineReader.setLineHandler(handler);
        } else if (arg instanceof CharBuffer) {
            lineReader = new CharBufferLineReader((CharBuffer)arg);
            ((CharBufferLineReader)lineReader).setLineHandler(handler);
        } else if (arg instanceof CharSequence) {
            lineReader = new CharBufferLineReader(CharBuffer.wrap((CharSequence)arg));
            ((CharBufferLineReader)lineReader).setLineHandler(handler);
        } else {
            throw new IllegalArgumentException();
        }
        return lineReader;
    }

    static LineHandler getLineHandler(Object arg, Context context) {
        if (arg instanceof PnutsFunction) {
            return new CallbackLineHandler((PnutsFunction)arg, context);
        }
        if (arg instanceof Collection) {
            return new CollectionLineHandler((Collection)arg);
        }
        if (arg == null) {
            return new LineHandler(){

                public void process(char[] c, int offset, int length) {
                }
            };
        }
        throw new IllegalArgumentException();
    }

    protected Object exec(Object[] args, Context context) {
        boolean includeNewLine = false;
        Object arg0 = args[0];
        AbstractLineReader lineReader = null;
        switch (args.length) {
            case 3: {
                includeNewLine = (Boolean)args[2];
            }
            case 2: {
                try {
                    LineHandler handler = scanLines.getLineHandler(args[1], context);
                    lineReader = scanLines.getLineReader(arg0, handler, context);
                    if (handler instanceof CallbackLineHandler) {
                        CallbackLineHandler h = (CallbackLineHandler)handler;
                        h.setLineReader(lineReader);
                        h.setTerminator(Boolean.FALSE);
                    }
                    Integer n = new Integer(lineReader.processAll(includeNewLine));
                    return n;
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
                finally {
                    if (arg0 instanceof String || arg0 instanceof File || arg0 instanceof URL) {
                        try {
                            ((LineReader)lineReader).close();
                        }
                        catch (IOException e2) {
                            throw new PnutsException((Throwable)e2, context);
                        }
                    }
                }
            }
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function scanLines((inputStream|reader|file|fileName|url), (func(line) | collection) {, includeNewLine })";
    }
}

