/*
 * Decompiled with CFR 0.152.
 */
package pnuts.regex.jsr51;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.regex.jsr51.CharSequenceList;
import pnuts.regex.jsr51.IntList;
import pnuts.regex.jsr51.MatchContext;

class PatternMatchHelper {
    String lastExpr;
    String lastOption;
    Pattern pattern;
    static final Object[] NO_PARAM = new Object[0];
    static final String CONTEXT_SYMBOL = "pnuts.regex.jsr51".intern();
    static MatchContext mc = new MatchContext();

    PatternMatchHelper() {
    }

    static String escapePattern(String pattern) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sbuf.append('\\');
                }
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    synchronized Pattern getPattern(String expr, String option, Context context) {
        Pattern p;
        if ((expr == this.lastExpr || expr.equals(this.lastExpr)) && (option == this.lastOption || option != null && option.equals(this.lastOption))) {
            p = this.pattern;
        } else {
            int flag = 0;
            if (option != null) {
                block11: for (int i = 0; i < option.length(); ++i) {
                    switch (option.charAt(i)) {
                        case 'i': {
                            flag |= 2;
                            continue block11;
                        }
                        case 's': {
                            flag |= 0x20;
                            continue block11;
                        }
                        case 'm': {
                            flag |= 8;
                            continue block11;
                        }
                        case 'u': {
                            flag |= 0x40;
                            continue block11;
                        }
                        case 'c': {
                            flag |= 0x80;
                            continue block11;
                        }
                        case 'n': {
                            expr = PatternMatchHelper.escapePattern(expr);
                            continue block11;
                        }
                        case 'g': {
                            continue block11;
                        }
                        default: {
                            throw new PnutsException("pnuts.regex.errors", "illegal.regex.option", new Object[]{option}, context);
                        }
                    }
                }
            }
            try {
                p = this.pattern = Pattern.compile(expr, flag);
                this.lastExpr = expr;
                this.lastOption = option;
            }
            catch (PatternSyntaxException e) {
                throw new PnutsException("pnuts.regex.errors", "illegal.regex.pattern", new Object[]{expr}, context);
            }
        }
        return p;
    }

    static Object split(Pattern pattern, CharSequence input) {
        Matcher m = pattern.matcher(input);
        ArrayList list2 = new ArrayList();
        IntList start = new IntList();
        IntList end = new IntList();
        int off = 0;
        while (m.find()) {
            start.add(off);
            end.add(m.start());
            off = m.end();
        }
        start.add(off);
        end.add(input.length());
        int size2 = start.size();
        int[] s = new int[size2];
        int[] e = new int[size2];
        start.copyInto(s);
        end.copyInto(e);
        return new CharSequenceList(input, s, e);
    }

    static boolean match(Pattern pattern, CharSequence input, MatchContext mc) {
        Matcher m = pattern.matcher(input);
        boolean result = m.find();
        mc.matcher = m;
        mc.count = result ? 1 : 0;
        return result;
    }

    static String getMatch(int idx, MatchContext mc) {
        Matcher matcher = mc.matcher;
        if (matcher == null) {
            return null;
        }
        try {
            return matcher.group(idx);
        }
        catch (Exception e1) {
            return null;
        }
    }

    static int getMatchStart(int idx, MatchContext mc) {
        Matcher matcher = mc.matcher;
        if (matcher == null) {
            return -1;
        }
        try {
            return matcher.start(idx);
        }
        catch (Exception e1) {
            return -1;
        }
    }

    static int getMatchEnd(int idx, MatchContext mc) {
        Matcher matcher = mc.matcher;
        if (matcher == null) {
            return -1;
        }
        try {
            return matcher.end(idx);
        }
        catch (Exception e1) {
            return -1;
        }
    }

    static int getNumberOfGroups(MatchContext mc) {
        Matcher matcher = mc.matcher;
        if (matcher != null) {
            return matcher.groupCount();
        }
        return -1;
    }

    static int getMatchCount(MatchContext mc) {
        return mc.count;
    }

    static Object matchAll(Pattern pattern, CharSequence input, Context context) {
        Matcher matcher = pattern.matcher(input);
        boolean result = matcher.find();
        int matchCount = 0;
        while (result) {
            ++matchCount;
            result = matcher.find();
        }
        return new Integer(matchCount);
    }

    static Object matchAll(Pattern pattern, CharSequence input, PnutsFunction func, Context context) {
        Matcher matcher = pattern.matcher(input);
        if (func != null && !func.defined(1) && !func.defined(-1)) {
            throw new IllegalArgumentException();
        }
        if (func != null) {
            boolean result = matcher.find();
            int matchCount = 0;
            if (result) {
                MatchContext mc = new MatchContext();
                mc.matcher = matcher;
                while (result) {
                    ++matchCount;
                    Context ctx = (Context)context.clone();
                    ctx.set(CONTEXT_SYMBOL, (Object)mc);
                    func.call(new Object[]{input.subSequence(matcher.start(), matcher.end())}, ctx);
                    result = matcher.find();
                }
            }
            return new Integer(matchCount);
        }
        return new MatchIterator(matcher, input);
    }

    static Object substitute(Pattern pattern, Object replacement, CharSequence input, boolean g_option, boolean n_option, MatchContext mc, Context context) {
        CharSequence ret;
        Matcher m;
        mc.matcher = m = pattern.matcher(input);
        int len = input.length();
        int matchCount = 0;
        if (replacement instanceof CharSequence) {
            if (n_option) {
                boolean result = m.find();
                if (result) {
                    int idx = 0;
                    StringBuffer sbuf = new StringBuffer(len);
                    if (g_option) {
                        while (result) {
                            int start = m.start();
                            sbuf.append(input.subSequence(idx, start));
                            sbuf.append(replacement);
                            idx = m.end();
                            if (idx == len) break;
                            result = m.find();
                        }
                        sbuf.append(input.subSequence(idx, input.length()));
                    } else {
                        int start = m.start();
                        sbuf.append(input.subSequence(0, start));
                        sbuf.append(replacement);
                        idx = m.end();
                        sbuf.append(input.subSequence(idx, input.length()));
                    }
                    ret = sbuf.toString();
                } else {
                    ret = input;
                }
            } else {
                StringBuffer sb = new StringBuffer(len);
                m.reset();
                String str = replacement.toString();
                boolean result = m.find();
                if (result) {
                    if (g_option) {
                        while (result) {
                            ++matchCount;
                            m.appendReplacement(sb, str);
                            result = m.find();
                        }
                    } else {
                        ++matchCount;
                        m.appendReplacement(sb, str);
                    }
                    m.appendTail(sb);
                    ret = sb.toString();
                } else {
                    ret = input;
                }
            }
        } else if (replacement instanceof PnutsFunction) {
            PnutsFunction func = (PnutsFunction)replacement;
            if (!func.defined(0) && !func.defined(-1)) {
                throw new IllegalArgumentException();
            }
            StringBuffer sbuf = new StringBuffer(len);
            boolean result = m.find();
            int idx = 0;
            if (result) {
                while (result) {
                    ++matchCount;
                    int start = m.start();
                    sbuf.append(input.subSequence(idx, start));
                    Context ctx = (Context)context.clone();
                    mc.matcher = m;
                    ctx.set(CONTEXT_SYMBOL, (Object)mc);
                    Object v = func.call(NO_PARAM, ctx);
                    if (v instanceof String) {
                        sbuf.append((String)v);
                    }
                    if ((idx = m.end()) == len || !g_option) break;
                    result = m.find();
                }
            }
            sbuf.append(input.subSequence(idx, input.length()));
            ret = sbuf.toString();
        } else {
            throw new IllegalArgumentException();
        }
        mc.count = matchCount;
        return ret;
    }

    public void registerAll(Package pkg, Context context) {
        pkg.set("match".intern(), (Object)new match(), context);
        pkg.set("matchAll".intern(), (Object)new matchAll(), context);
        pkg.set("split".intern(), (Object)new split(), context);
        pkg.set("substitute".intern(), (Object)new substitute(), context);
        pkg.set("formatMatch".intern(), (Object)new formatMatch(), context);
        pkg.set("regex".intern(), (Object)new regex(), context);
        pkg.set("getMatch".intern(), (Object)new getMatch(), context);
        pkg.set("getMatches".intern(), (Object)new getMatches(), context);
        pkg.set("getMatchStart".intern(), (Object)new getMatchStart(), context);
        pkg.set("getMatchEnd".intern(), (Object)new getMatchEnd(), context);
        pkg.set("getNumberOfGroups".intern(), (Object)new getNumberOfGroups(), context);
        pkg.set("getMatchCount".intern(), (Object)new getMatchCount(), context);
        pkg.set("whichRegexAPI".intern(), (Object)new whichRegexAPI(), context);
    }

    class whichRegexAPI
    extends PnutsFunction {
        public whichRegexAPI() {
            super("whichRegexAPI");
        }

        public boolean defined(int narg) {
            return narg == 0;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 0) {
                return CONTEXT_SYMBOL;
            }
            this.undefined(args, context);
            return null;
        }

        public String toString() {
            return "function whichRegexAPI()";
        }
    }

    class getMatchCount
    extends PnutsFunction {
        public getMatchCount() {
            super("getMatchCount");
        }

        public boolean defined(int narg) {
            return narg == 0;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length != 0) {
                this.undefined(args, context);
                return null;
            }
            MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
            if (mc != null) {
                return new Integer(PatternMatchHelper.getMatchCount(mc));
            }
            return new Integer(0);
        }

        public String toString() {
            return "function getMatchCount()";
        }
    }

    class getNumberOfGroups
    extends PnutsFunction {
        public getNumberOfGroups() {
            super("getNumberOfGroups");
        }

        public boolean defined(int narg) {
            return narg == 0;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 0) {
                MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
                if (mc == null) {
                    return null;
                }
                int num = PatternMatchHelper.getNumberOfGroups(mc);
                if (num < 0) {
                    return null;
                }
                return new Integer(num);
            }
            this.undefined(args, context);
            return null;
        }

        public String toString() {
            return "function getNumberOfGroups()";
        }
    }

    class getMatchEnd
    extends PnutsFunction {
        public getMatchEnd() {
            super("getMatchEnd");
        }

        public boolean defined(int narg) {
            return narg == 1;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 1) {
                MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
                if (mc == null) {
                    return null;
                }
                int idx = (Integer)args[0];
                int end = PatternMatchHelper.getMatchEnd(idx, mc);
                if (end >= 0) {
                    return new Integer(end);
                }
                return null;
            }
            this.undefined(args, context);
            return null;
        }

        public String toString() {
            return "function getMatchEnd(int n)";
        }
    }

    class getMatchStart
    extends PnutsFunction {
        public getMatchStart() {
            super("getMatchStart");
        }

        public boolean defined(int narg) {
            return narg == 1;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 1) {
                MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
                if (mc == null) {
                    return null;
                }
                int idx = (Integer)args[0];
                int start = PatternMatchHelper.getMatchStart(idx, mc);
                if (start >= 0) {
                    return new Integer(start);
                }
                return null;
            }
            this.undefined(args, context);
            return null;
        }

        public String toString() {
            return "function getMatchStart(int n)";
        }
    }

    class getMatches
    extends PnutsFunction {
        public getMatches() {
            super("getMatches");
        }

        public boolean defined(int narg) {
            return narg == 0;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 0) {
                MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
                if (mc == null) {
                    return null;
                }
                Matcher matcher = mc.matcher;
                if (matcher != null) {
                    int c = matcher.groupCount();
                    Object[] array = new Object[c];
                    for (int i = 0; i < c; ++i) {
                        array[i] = PatternMatchHelper.getMatch(i + 1, mc);
                    }
                    return array;
                }
                return null;
            }
            this.undefined(args, context);
            return null;
        }

        public String toString() {
            return "function getMatches()";
        }
    }

    class getMatch
    extends PnutsFunction {
        public getMatch() {
            super("getMatch");
        }

        public boolean defined(int narg) {
            return narg == 1;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 1) {
                MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
                if (mc == null) {
                    return null;
                }
                int idx = (Integer)args[0];
                return PatternMatchHelper.getMatch(idx, mc);
            }
            this.undefined(args, context);
            return null;
        }

        public String toString() {
            return "function getMatch(int n)";
        }
    }

    class regex
    extends PnutsFunction {
        public regex() {
            super("regex");
        }

        public boolean defined(int nargs) {
            return nargs == 1 || nargs == 2;
        }

        protected Object exec(Object[] args, Context context) {
            String option = null;
            int nargs = args.length;
            if (nargs == 2) {
                option = (String)args[1];
            } else if (nargs != 1) {
                this.undefined(args, context);
                return null;
            }
            Object expr = args[0];
            if (expr instanceof Pattern) {
                return expr;
            }
            if (expr instanceof String) {
                return PatternMatchHelper.this.getPattern((String)expr, option, context);
            }
            throw new IllegalArgumentException(String.valueOf(expr));
        }

        public String toString() {
            return "function regex(String pattern {, option })";
        }
    }

    class formatMatch
    extends PnutsFunction {
        public formatMatch() {
            super("formatMatch");
        }

        public boolean defined(int nargs) {
            return nargs == 1;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length != 1) {
                this.undefined(args, context);
                return null;
            }
            MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
            if (mc == null) {
                return null;
            }
            Matcher matcher = mc.matcher;
            if (matcher == null) {
                return null;
            }
            StringBuffer result = new StringBuffer();
            int cursor = 0;
            String replacement = args[0].toString();
            while (cursor < replacement.length()) {
                char nextChar = replacement.charAt(cursor);
                if (nextChar == '\\') {
                    nextChar = replacement.charAt(++cursor);
                    result.append(nextChar);
                    ++cursor;
                    continue;
                }
                if (nextChar == '$') {
                    int nextDigit;
                    int refNum;
                    if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                        throw new IllegalArgumentException("Illegal group reference");
                    }
                    ++cursor;
                    boolean done = false;
                    while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                        int newRefNum = refNum * 10 + nextDigit;
                        if (matcher.groupCount() < newRefNum) {
                            done = true;
                            continue;
                        }
                        refNum = newRefNum;
                        ++cursor;
                    }
                    if (matcher.group(refNum) == null) continue;
                    result.append(matcher.group(refNum));
                    continue;
                }
                result.append(nextChar);
                ++cursor;
            }
            return result.toString();
        }

        public String toString() {
            return "function formatMatch(String template)";
        }
    }

    class matchAll
    extends PnutsFunction {
        public matchAll() {
            super("matchAll");
        }

        public boolean defined(int nargs) {
            return nargs == 2 || nargs == 3 || nargs == 4;
        }

        protected Object exec(Object[] args, Context context) {
            Pattern p;
            String option;
            PnutsFunction func;
            boolean nullfunc = false;
            int nargs = args.length;
            if (nargs == 4) {
                func = (PnutsFunction)args[2];
                if (func == null) {
                    nullfunc = true;
                }
                option = (String)args[3];
            } else if (nargs == 3) {
                func = (PnutsFunction)args[2];
                if (func == null) {
                    nullfunc = true;
                }
                option = null;
            } else if (nargs == 2) {
                func = null;
                option = null;
            } else {
                this.undefined(args, context);
                return null;
            }
            Object arg0 = args[0];
            if (arg0 instanceof Pattern) {
                p = (Pattern)arg0;
            } else if (arg0 instanceof String) {
                p = PatternMatchHelper.this.getPattern((String)arg0, option, context);
            } else {
                throw new IllegalArgumentException(String.valueOf(arg0));
            }
            if (nullfunc) {
                return PatternMatchHelper.matchAll(p, (CharSequence)args[1], context);
            }
            return PatternMatchHelper.matchAll(p, (CharSequence)args[1], func, context);
        }

        public String toString() {
            return "function matchAll(pattern, CharSequence {, func() {, options }} )";
        }
    }

    class substitute
    extends PnutsFunction {
        public substitute() {
            super("substitute");
        }

        public boolean defined(int narg) {
            return narg == 3 || narg == 4;
        }

        protected Object exec(Object[] args, Context context) {
            Pattern p;
            String option;
            int nargs = args.length;
            if (nargs == 4) {
                option = (String)args[3];
            } else if (nargs == 3) {
                option = null;
            } else {
                this.undefined(args, context);
                return null;
            }
            Object arg0 = args[0];
            if (arg0 instanceof Pattern) {
                p = (Pattern)arg0;
            } else if (arg0 instanceof String) {
                p = PatternMatchHelper.this.getPattern((String)arg0, option, context);
            } else {
                throw new IllegalArgumentException(String.valueOf(arg0));
            }
            boolean g_option = option != null && option.indexOf(103) >= 0;
            boolean n_option = option != null && option.indexOf(110) >= 0;
            Object replacement = args[1];
            CharSequence input = (CharSequence)args[2];
            MatchContext mc = new MatchContext();
            context.set(CONTEXT_SYMBOL, (Object)mc);
            return PatternMatchHelper.substitute(p, replacement, input, g_option, n_option, mc, context);
        }

        public String toString() {
            return "function substitute(pattern, (func()|CharSequence) replacement, CharSequence input {, options } )";
        }
    }

    class match
    extends PnutsFunction {
        public match() {
            super("match");
        }

        public boolean defined(int narg) {
            return narg == 2 || narg == 3;
        }

        protected Object exec(Object[] args, Context context) {
            Pattern p;
            String option;
            int nargs = args.length;
            if (nargs == 3) {
                option = (String)args[2];
            } else if (nargs == 2) {
                option = null;
            } else {
                this.undefined(args, context);
                return null;
            }
            Object arg0 = args[0];
            if (arg0 instanceof Pattern) {
                p = (Pattern)arg0;
            } else if (arg0 instanceof String) {
                p = PatternMatchHelper.this.getPattern((String)arg0, option, context);
            } else {
                throw new IllegalArgumentException(String.valueOf(arg0));
            }
            CharSequence input = (CharSequence)args[1];
            MatchContext mc = (MatchContext)context.get(CONTEXT_SYMBOL);
            if (mc == null) {
                mc = new MatchContext();
                context.set(CONTEXT_SYMBOL, (Object)mc);
            }
            return new Boolean(PatternMatchHelper.match(p, input, mc));
        }

        public String toString() {
            return "function match(pattern, CharSequence input {, options } )";
        }
    }

    class split
    extends PnutsFunction {
        public split() {
            super("split");
        }

        public boolean defined(int nargs) {
            return nargs == 2 || nargs == 3;
        }

        protected Object exec(Object[] args, Context context) {
            Pattern p;
            String option;
            int nargs = args.length;
            if (nargs == 3) {
                option = (String)args[2];
            } else if (nargs == 2) {
                option = null;
            } else {
                this.undefined(args, context);
                return null;
            }
            Object arg0 = args[0];
            if (arg0 instanceof Pattern) {
                p = (Pattern)arg0;
            } else if (arg0 instanceof String) {
                p = PatternMatchHelper.this.getPattern((String)arg0, option, context);
            } else {
                throw new IllegalArgumentException(String.valueOf(arg0));
            }
            CharSequence input = (CharSequence)args[1];
            return PatternMatchHelper.split(p, input);
        }

        public String toString() {
            return "function split(pattern, CharSequence {, options })";
        }
    }

    static class MatchIterator
    implements Iterator {
        boolean checkNeeded = true;
        Matcher matcher;
        CharSequence input;
        boolean result;

        MatchIterator(Matcher matcher, CharSequence input) {
            this.matcher = matcher;
            this.input = input;
        }

        synchronized void check() {
            if (this.checkNeeded) {
                this.result = this.matcher.find();
                this.checkNeeded = false;
            }
        }

        public boolean hasNext() {
            this.check();
            return this.result;
        }

        public Object next() {
            this.check();
            if (!this.result) {
                throw new NoSuchElementException();
            }
            this.checkNeeded = true;
            return this.input.subSequence(this.matcher.start(), this.matcher.end());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

