/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultipartInputStream
extends FilterInputStream {
    private byte[] boundary;
    private byte[] buffer;
    private boolean partEnd;
    private boolean fileEnd;

    protected MultipartInputStream(InputStream in) {
        super(in);
    }

    public MultipartInputStream(InputStream in, byte[] boundary) {
        super(in);
        if (!in.markSupported()) {
            this.in = new BufferedInputStream(in, boundary.length + 4);
        }
        this.boundary = boundary;
        this.buffer = new byte[boundary.length];
        this.partEnd = false;
        this.fileEnd = false;
    }

    private final boolean readBoundaryBytes() throws IOException {
        int got;
        for (int pos = 0; pos < this.buffer.length; pos += got) {
            got = this.in.read(this.buffer, pos, this.buffer.length - pos);
            if (got >= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean skipToBoundary() throws IOException {
        int ch = this.in.read();
        block0: while (ch != -1) {
            if (ch != 45) {
                ch = this.in.read();
                continue;
            }
            ch = this.in.read();
            if (ch != 45) continue;
            this.in.mark(this.boundary.length);
            if (!this.readBoundaryBytes()) {
                this.in.reset();
                ch = this.in.read();
                continue;
            }
            for (int i = 0; i < this.boundary.length; ++i) {
                if (this.buffer[i] == this.boundary[i]) continue;
                this.in.reset();
                ch = this.in.read();
                continue block0;
            }
            ch = this.in.read();
            if (ch == 13) {
                ch = this.in.read();
            }
            this.in.mark(3);
            if (this.in.read() == 45 && this.in.read() == 13 && this.in.read() == 10) {
                this.fileEnd = true;
                return false;
            }
            this.in.reset();
            return true;
        }
        this.fileEnd = true;
        return false;
    }

    public int read() throws IOException {
        if (this.partEnd) {
            return -1;
        }
        int ch = this.in.read();
        switch (ch) {
            case 13: {
                this.in.mark(this.boundary.length + 3);
                int c1 = this.in.read();
                int c2 = this.in.read();
                int c3 = this.in.read();
                if (c1 == 10 && c2 == 45 && c3 == 45) {
                    if (!this.readBoundaryBytes()) {
                        this.reset();
                        return ch;
                    }
                    for (int i = 0; i < this.boundary.length; ++i) {
                        if (this.buffer[i] == this.boundary[i]) continue;
                        this.in.reset();
                        return ch;
                    }
                    this.partEnd = true;
                    ch = this.in.read();
                    if (ch == 13) {
                        this.in.read();
                    } else if (ch == 45) {
                        if (this.in.read() == 45) {
                            this.fileEnd = true;
                        }
                    } else {
                        this.fileEnd = ch == -1;
                    }
                    return -1;
                }
                this.in.reset();
                return ch;
            }
            case -1: {
                this.fileEnd = true;
                return -1;
            }
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int got = 0;
        while (got < len) {
            int ch = this.read();
            if (ch == -1) {
                return got == 0 ? -1 : got;
            }
            b[off + got++] = (byte)ch;
        }
        return got;
    }

    public long skip(long n) throws IOException {
        while (--n >= 0L && this.read() != -1) {
        }
        return n;
    }

    public boolean next() throws IOException {
        if (this.fileEnd) {
            return false;
        }
        if (!this.partEnd) {
            return this.skipToBoundary();
        }
        this.partEnd = false;
        return true;
    }
}

