/*
 * Decompiled with CFR 0.152.
 */
package pnuts.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import pnuts.xml.AttributeMap;
import pnuts.xml.DigestAction;
import pnuts.xml.LocalNameMap;
import pnuts.xml.RuleSet;
import pnuts.xml.SAXException;
import pnuts.xml.SimpleRuleSet;
import pnuts.xml.TargetHandler;

public class DigestHandler
extends DefaultHandler {
    private AttributeMap attributeMap;
    private boolean useLocalNames;
    private List stack;
    private StringBuffer sbuf;
    private Object value;
    private List valueStack;
    private List paths;
    private String path;
    Stack listPaths;
    Stack listValues;
    private RuleSet ruleSet;

    public DigestHandler() {
        this(new SimpleRuleSet());
    }

    public DigestHandler(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public void setUseLocalNames(boolean useLocalNames) {
        this.useLocalNames = useLocalNames;
    }

    public boolean isUseLocalNames() {
        return this.useLocalNames;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    void initialize() {
        this.path = "";
        this.stack = new ArrayList();
        this.sbuf = new StringBuffer(64);
        this.paths = new ArrayList();
        this.valueStack = new ArrayList();
        this.listPaths = new Stack();
        this.listValues = new Stack();
        this.pushValue("", this.value);
        this.attributeMap = this.useLocalNames ? new LocalNameMap() : new AttributeMap();
    }

    public void addRule(DigestAction action, String path) {
        this.addRule(action, path, null);
    }

    public void addRule(DigestAction action, String path, String keyword) {
        if (action != null) {
            action.handler = this;
            this.ruleSet.add(path, action, keyword);
        }
    }

    String getKey(String path) {
        String base = this.getStackTopPath();
        if (DigestHandler.sameBranch(path, base) && base.length() + 1 < path.length()) {
            return path.substring(base.length() + 1);
        }
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            return path.substring(idx + 1);
        }
        return path;
    }

    static boolean sameBranch(String longer, String shorter) {
        int idx = longer.indexOf(shorter);
        if (idx < 0) {
            return false;
        }
        int len2 = shorter.length();
        if (longer.length() == len2) {
            return true;
        }
        return longer.charAt(len2) == '/';
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws org.xml.sax.SAXException {
        this.stack.add(qName);
        String _path = this.path;
        StringBuffer sb = new StringBuffer(_path);
        sb.append('/');
        sb.append(qName);
        final String path = this.path = sb.toString();
        for (int pos = this.paths.size() - 1; pos > 0 && !DigestHandler.sameBranch(path, (String)this.paths.get(pos)); --pos) {
            this.popValue();
        }
        this.attributeMap.setAttributes(attributes);
        final String defaultKey = this.getKey(path);
        try {
            this.ruleSet.scan(path, this.stack, new TargetHandler(){

                public void handle(DigestAction action, String keyword) throws Exception {
                    if (keyword == null) {
                        keyword = defaultKey;
                    }
                    action.start(path, keyword, DigestHandler.this.attributeMap, DigestHandler.this.getStackTopValue());
                }
            });
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws org.xml.sax.SAXException {
        final String path = this.path;
        String valuePath = this.getStackTopPath();
        int pos = this.paths.size() - 1;
        if (pos > 0 && !DigestHandler.sameBranch(path, valuePath)) {
            this.popValue();
            --pos;
            valuePath = this.getStackTopPath();
        }
        final String defaultKey = this.getKey(path);
        final String text = this.sbuf.toString().trim();
        try {
            this.ruleSet.scan(path, this.stack, new TargetHandler(){

                public void handle(DigestAction action, String keyword) throws Exception {
                    if (keyword == null) {
                        keyword = defaultKey;
                    }
                    action.end(path, keyword, text, DigestHandler.this.getStackTopValue());
                }
            });
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.sbuf.setLength(0);
        this.stack.remove(this.stack.size() - 1);
        int idx = path.lastIndexOf(47);
        this.path = idx > 0 ? path.substring(0, idx) : "";
    }

    Object getStackTopValue() {
        return this.valueStack.get(this.valueStack.size() - 1);
    }

    String getStackTopPath() {
        return (String)this.paths.get(this.paths.size() - 1);
    }

    void pushValue(String path, Object value) {
        this.paths.add(path);
        this.valueStack.add(value);
    }

    Object popValue() {
        this.paths.remove(this.paths.size() - 1);
        Object value = this.valueStack.remove(this.valueStack.size() - 1);
        if (!this.listValues.isEmpty() && value == this.listValues.peek()) {
            this.listPaths.pop();
            this.listValues.pop();
        }
        return value;
    }

    public synchronized void registerListPath(String path, Object list2) {
        this.listPaths.push(path);
        this.listValues.push(list2);
    }

    public boolean listAlive(String path) {
        return this.listPaths.size() > 0 && this.listPaths.peek().equals(path);
    }

    public Object currentListValue() {
        return this.listValues.peek();
    }

    public void characters(char[] ch, int start, int length) throws org.xml.sax.SAXException {
        this.sbuf.append(ch, start, length);
    }

    public void startDocument() throws org.xml.sax.SAXException {
        this.initialize();
    }
}

