/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import jp.co.argo21.nautica.workflow.filter.AttributeFilter;
import jp.co.argo21.nautica.workflow.filter.FilterConverter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

public class ActivityFilterConverter
implements FilterConverter {
    private boolean hasAttributeFilter;

    public String convertToSQL(Filter filter) throws InvalidFilterException {
        String sql = "";
        if (filter != null) {
            if (filter instanceof AttributeFilter) {
                sql = this.convertToSQL((AttributeFilter)filter);
            } else if (filter instanceof StateFilter) {
                sql = this.convertToSQL((StateFilter)filter);
            } else if (filter instanceof GroupFilter) {
                sql = this.convertToSQL((GroupFilter)filter);
            } else {
                String errMsg = StringManager.get("E0004");
                throw new InvalidFilterException(errMsg);
            }
        }
        if (this.hasAttributeFilter) {
            sql = sql + " AND a.PROC_ID = v.PROC_ID ";
        }
        return sql;
    }

    private String convertToSQL(AttributeFilter filter) throws InvalidFilterException {
        String name = filter.getFilterName();
        if (name == null) {
            String errMsg = StringManager.get("E0004");
            throw new InvalidFilterException(errMsg);
        }
        name = "'" + name + "'";
        this.hasAttributeFilter = true;
        String fs = filter.getFilterString();
        fs = fs == null ? "NULL" : "'" + fs + "'";
        String sql = "( v.NAME = " + name + " AND v." + "VALUE" + this.getComparisonString(filter.getComparison()) + fs + ")";
        return sql;
    }

    private String convertToSQL(StateFilter filter) throws InvalidFilterException {
        String fs = filter.getFilterString();
        if (fs == null) {
            String errMsg = StringManager.get("E0004");
            throw new InvalidFilterException(errMsg);
        }
        fs = "'a." + fs + "'";
        return "a.ACT_STATE = " + filter.getFilterString();
    }

    private String convertToSQL(GroupFilter filter) throws InvalidFilterException {
        Filter[] children = filter.getChild();
        int count = children.length;
        if (count == 0) {
            return "";
        }
        String s = this.convertToSQL(children[0]);
        for (int i = 1; i < count; ++i) {
            s = s + " AND " + this.convertToSQL(children[0]);
        }
        return s;
    }

    private String getComparisonString(int comparison) {
        switch (comparison) {
            case 1: {
                return " = ";
            }
            case 6: {
                return " >= ";
            }
            case 5: {
                return " > ";
            }
            case 4: {
                return " <= ";
            }
            case 3: {
                return " < ";
            }
            case 2: {
                return " <> ";
            }
            case 7: {
                return " LIKE ";
            }
        }
        return " <> ";
    }

    public boolean hasAttributeFilter() {
        return this.hasAttributeFilter;
    }
}

