/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.ActivityFilterConverter;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import org.apache.log4j.Logger;

public class MySQLActivityDAO
extends AbstractDAO
implements ActivityDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROC_ID = "PROC_ID";
    public static final String ACT_ID = "ACT_ID";
    public static final String ACT_DEF_ID = "ACT_DEF_ID";
    public static final String START_DATE = "START_DATE";
    public static final String STARTER_ID = "STARTER_ID";
    public static final String DURATION_LIMIT = "DURATION_LIMIT";
    public static final String BLOCK_ID = "BLOCK_ID";
    public static final String ACT_STATE = "ACT_STATE";
    public static final String ACTOR_ID = "ACTOR_ID";
    public static final String UPDATE_DATE = "UPDATE_DATE";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from ACTIVITY where PROC_ID = ? AND ACT_ID = ?";
    private static final String SQL_SELECT_COUNT_OPEN_BY_BLOCK_ID = "select COUNT(*) from ACTIVITY where PROC_ID = ? AND BLOCK_ID = ? AND ACT_STATE < 4 ";
    private static final String SQL_SELECT_COUNT_OPEN_BY_PROC_ID = "select COUNT(*) from ACTIVITY where PROC_ID = ? AND ACT_STATE < 4 ";
    private static final String SQL_SELECT_OPEN_BY_PROC_ID = "select * from ACTIVITY where PROC_ID = ? AND ACT_STATE < 4 ";
    private static final String SQL_SELECT_CONCUREND = "select * from ACTIVITY where PROC_ID = ? AND ACT_DEF_ID = ? AND BLOCK_ID = ? ";
    private static final String SQL_SELECT_WITH_VAR = "select distinct a.* from ACTIVITY a, VARIABLE v ";
    private static final String SQL_SELECT = "select distinct a.* from ACTIVITY a ";
    private static final String SQL_SELECT_PDID_WITH_VAR = "select distinct a.* from PROCESS p, ACTIVITY a, VARIABLE v ";
    private static final String SQL_SELECT_PDID = "select distinct a.* from PROCESS p, ACTIVITY a ";
    private static final String SQL_INSERT = "insert into ACTIVITY (PROC_ID, ACT_ID, ACT_DEF_ID, START_DATE, STARTER_ID, DURATION_LIMIT, BLOCK_ID, ACT_STATE, ACTOR_ID, UPDATE_DATE) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE_STATE = "UPDATE ACTIVITY SET ACT_STATE = ?, UPDATE_DATE = ? WHERE ACT_ID = ? ";
    private static final String SQL_UPDATE_DATE = "UPDATE ACTIVITY SET UPDATE_DATE = ? WHERE ACT_ID = ? ";
    private static final String SQL_UPDATE_BLOCK_ID = "UPDATE ACTIVITY SET BLOCK_ID = ? WHERE ACT_ID = ? ";

    MySQLActivityDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityBean findByPrimaryKey(String pid, String aid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, pid);
            st.setString(2, aid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ActivityBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ActivityBean activityBean = bean;
            return activityBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findOpeningActivityCountByBlockID(String pid, String bid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_COUNT_OPEN_BY_BLOCK_ID);
        try {
            st.setString(1, pid);
            st.setString(2, bid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findOpeningActivityCountByProcessID(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_COUNT_OPEN_BY_PROC_ID);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityBean[] findOpeningActivityByProcessID(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_OPEN_BY_PROC_ID);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<ActivityBean> list = new ArrayList<ActivityBean>();
            while (rs.next()) {
                ActivityBean bean = this.createBean(rs);
                list.add(bean);
            }
            ActivityBean[] activityBeanArray = list.toArray(new ActivityBean[list.size()]);
            return activityBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityBean findConcurrentEnd(String pid, String adid, String bid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_CONCUREND);
        try {
            st.setString(1, pid);
            st.setString(2, adid);
            st.setString(3, bid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ActivityBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ActivityBean activityBean = bean;
            return activityBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityBean[] findByFilter(Filter filter) throws SQLException, DAOException, InvalidFilterException {
        ActivityFilterConverter converter = new ActivityFilterConverter();
        String where = converter.convertToSQL(filter);
        if (!where.equals("")) {
            where = " where " + where;
        }
        String sqlSelect = null;
        sqlSelect = converter.hasAttributeFilter() ? SQL_SELECT_WITH_VAR : SQL_SELECT;
        PreparedStatement st = this.getConnection().prepareStatement(sqlSelect + where);
        eLog.debug((Object)st.toString());
        try {
            ResultSet rs = st.executeQuery();
            ArrayList<ActivityBean> list = new ArrayList<ActivityBean>();
            while (rs.next()) {
                ActivityBean bean = this.createBean(rs);
                list.add(bean);
            }
            ActivityBean[] activityBeanArray = list.toArray(new ActivityBean[list.size()]);
            return activityBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityBean[] findByFilter(String pid, Filter filter) throws SQLException, DAOException, InvalidFilterException {
        ActivityFilterConverter converter = new ActivityFilterConverter();
        String where = converter.convertToSQL(filter);
        if (pid == null) {
            String errMsg = StringManager.get("E0004");
            throw new InvalidFilterException(errMsg);
        }
        where = where.equals("") ? " where a.PROC_ID = '" + pid + "' " : " where " + where + " AND a.PROC_ID = '" + pid + "' ";
        String sqlSelect = null;
        sqlSelect = converter.hasAttributeFilter() ? SQL_SELECT_WITH_VAR : SQL_SELECT;
        PreparedStatement st = this.getConnection().prepareStatement(sqlSelect + where);
        eLog.debug((Object)st.toString());
        try {
            ResultSet rs = st.executeQuery();
            ArrayList<ActivityBean> list = new ArrayList<ActivityBean>();
            while (rs.next()) {
                ActivityBean bean = this.createBean(rs);
                list.add(bean);
            }
            ActivityBean[] activityBeanArray = list.toArray(new ActivityBean[list.size()]);
            return activityBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityBean[] findByFilter(String pdid, String adid, Filter filter) throws SQLException, DAOException, InvalidFilterException {
        ActivityFilterConverter converter = new ActivityFilterConverter();
        String where = converter.convertToSQL(filter);
        where = where.equals("") ? " where p.PROC_DEF_ID = '" + pdid + "' " + "and p.PROC_ID = a.PROC_ID and a.ACT_DEF_ID = '" + adid + "' " : " where p.PROC_DEF_ID = '" + pdid + "' " + "and p.PROC_ID = a.PROC_ID and a.ACT_DEF_ID = '" + adid + "' and " + where;
        String sqlSelect = null;
        sqlSelect = converter.hasAttributeFilter() ? SQL_SELECT_PDID_WITH_VAR : SQL_SELECT_PDID;
        PreparedStatement st = this.getConnection().prepareStatement(sqlSelect + where);
        eLog.debug((Object)st.toString());
        try {
            ResultSet rs = st.executeQuery();
            ArrayList<ActivityBean> list = new ArrayList<ActivityBean>();
            while (rs.next()) {
                ActivityBean bean = this.createBean(rs);
                list.add(bean);
            }
            ActivityBean[] activityBeanArray = list.toArray(new ActivityBean[list.size()]);
            return activityBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ActivityBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getProcessID());
            st.setString(2, bean.getActivityID());
            st.setString(3, bean.getActivityDefinitionID());
            st.setTimestamp(4, bean.getStartDate());
            st.setString(5, bean.getStarterID());
            st.setTimestamp(6, bean.getDurationLimit());
            st.setString(7, bean.getBlockID());
            st.setInt(8, bean.getActivityState());
            st.setString(9, bean.getActorID());
            st.setTimestamp(10, bean.getUpdateDate());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0007");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            ActivityHistoryDAO ahDAO = factory.getActivityHistoryDAO();
            ActivityHistoryBean history = new ActivityHistoryBean();
            history.setProcID(bean.getProcessID());
            history.setActID(bean.getActivityID());
            history.setActDefID(bean.getActivityDefinitionID());
            history.setActorID(bean.getActorID());
            history.setPrevState(-1);
            history.setNewState(bean.getActivityState());
            history.setUpdateDate(bean.getUpdateDate());
            history.setReason("NEW ACTIVITY CREATION");
            ahDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0008");
            throw new DAOException(errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(ActivityBean bean, ActivityState state, Timestamp ts) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_STATE);
        try {
            st.setInt(1, state.toInt());
            st.setTimestamp(2, ts);
            st.setString(3, bean.getActivityID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0010");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            ActivityHistoryDAO ahDAO = factory.getActivityHistoryDAO();
            ActivityHistoryBean history = new ActivityHistoryBean();
            history.setProcID(bean.getProcessID());
            history.setActID(bean.getActivityID());
            history.setActDefID(bean.getActivityDefinitionID());
            history.setActorID(bean.getActorID());
            history.setPrevState(bean.getActivityState());
            history.setNewState(state.toInt());
            history.setUpdateDate(bean.getUpdateDate());
            ActivityState old = ActivityState.getState(bean.getActivityState());
            String msg = "ACTIVITY STATE CHANGED FROM " + old.toString() + " TO " + state.toString();
            history.setReason(msg);
            ahDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0011");
            throw new DAOException(errMsg);
        }
        bean.setUpdateDate(ts);
        bean.setActivityState(state.toInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(ActivityBean bean, Timestamp ts) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_DATE);
        try {
            st.setTimestamp(1, ts);
            st.setString(2, bean.getActivityID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0010");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            ActivityState old = ActivityState.getState(bean.getActivityState());
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            ActivityHistoryDAO ahDAO = factory.getActivityHistoryDAO();
            ActivityHistoryBean history = new ActivityHistoryBean();
            history.setProcID(bean.getProcessID());
            history.setActID(bean.getActivityID());
            history.setActDefID(bean.getActivityDefinitionID());
            history.setActorID(bean.getActorID());
            history.setPrevState(bean.getActivityState());
            history.setNewState(old.toInt());
            history.setUpdateDate(bean.getUpdateDate());
            String msg = "PROCESS STATE NOTIFIED FROM " + old.toString();
            history.setReason(msg);
            ahDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0011");
            throw new DAOException(errMsg);
        }
        bean.setUpdateDate(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockID(ActivityBean bean, String bid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_BLOCK_ID);
        try {
            st.setString(1, bid);
            st.setString(2, bean.getActivityID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0009");
                throw new DAOException(errMsg);
            }
            bean.setBlockID(bid);
        }
        finally {
            st.close();
        }
    }

    private ActivityBean createBean(ResultSet rs) throws SQLException {
        ActivityBean bean = new ActivityBean();
        bean.setProcessID(rs.getString(PROC_ID));
        bean.setActivityID(rs.getString(ACT_ID));
        bean.setActivityDefinitionID(rs.getString(ACT_DEF_ID));
        bean.setStartDate(rs.getTimestamp(START_DATE));
        bean.setStarterID(rs.getString(STARTER_ID));
        bean.setDurationLimit(rs.getTimestamp(DURATION_LIMIT));
        bean.setBlockID(rs.getString(BLOCK_ID));
        bean.setActivityState(rs.getInt(ACT_STATE));
        bean.setActorID(rs.getString(ACTOR_ID));
        bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
        return bean;
    }
}

