/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLVariableHistoryDAO
extends AbstractDAO
implements VariableHistoryDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String VAR_ID = "VAR_ID";
    public static final String PROC_ID = "PROC_ID";
    public static final String VAR_DEF_ID = "VAR_DEF_ID";
    public static final String TYPE = "TYPE";
    public static final String PREV_VALUE = "PREV_VALUE";
    public static final String NEW_VALUE = "NEW_VALUE";
    public static final String UPDATE_DATE = "UPDATE_DATE";
    public static final String REASON = "REASON";
    public static final String ACT_ID = "ACT_ID";
    private static final String SQL_INSERT = "insert into VARIABLEHIST (VAR_ID, PROC_ID, VAR_DEF_ID, TYPE, PREV_VALUE, NEW_VALUE, UPDATE_DATE, REASON, ACT_ID) values (?,?,?,?,?,?,?,?,?)";

    MySQLVariableHistoryDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(VariableHistoryBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getVarID());
            st.setString(2, bean.getProcID());
            st.setString(3, bean.getVarDefID());
            st.setInt(4, bean.getType());
            st.setString(5, bean.getPrevValue());
            st.setString(6, bean.getNewValue());
            st.setTimestamp(7, bean.getUpdateDate());
            st.setString(8, bean.getReason());
            st.setString(9, bean.getActivityID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0033");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private VariableHistoryBean createBean(ResultSet rs) throws SQLException {
        VariableHistoryBean bean = new VariableHistoryBean();
        bean.setVarID(rs.getString(VAR_ID));
        bean.setProcID(rs.getString(PROC_ID));
        bean.setVarDefID(rs.getString(VAR_DEF_ID));
        bean.setType(rs.getInt(TYPE));
        bean.setPrevValue(rs.getString(PREV_VALUE));
        bean.setNewValue(rs.getString(NEW_VALUE));
        bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
        bean.setReason(rs.getString(REASON));
        bean.setActivityID(rs.getString(ACT_ID));
        return bean;
    }
}

