/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Session;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.SimpleSession;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import org.apache.log4j.Logger;

public class SimpleSessionManager
implements SessionManager {
    private static final String PASSWORD = "PASSWORD";
    private static final long VALIDTERM = 1800000L;
    private static Logger sLog = LogManager.getSercurityLogger();
    private Map sessions = Collections.synchronizedMap(new HashMap());

    public SimpleSessionManager() {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new TimeoutTimerTask(this), 1800000L, 900000L);
    }

    public String createSession(String uid, String password) throws ConnectionFailedException {
        UserBean user = null;
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            UserManagerDAO usermanagerDAO = daoFactory.getUserManagerDAO();
            user = usermanagerDAO.findByUserID(uid);
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1010") + "(UserID=" + uid + ")";
            sLog.error((Object)errMsg);
            throw new ConnectionFailedException(errMsg, e);
        }
        if (user == null) {
            String errMsg = StringManager.get("E1011") + "(UserID=" + uid + ")";
            sLog.error((Object)errMsg);
            throw new ConnectionFailedException(errMsg);
        }
        String basepassword = "";
        try {
            basepassword = user.getAttribute(PASSWORD);
        }
        catch (WorkflowException e) {
            String errMsg = StringManager.get("E1012") + "(UserID=" + uid + ")";
            sLog.error((Object)errMsg);
            throw new ConnectionFailedException(errMsg, e);
        }
        if (!password.equals(basepassword)) {
            String errMsg = StringManager.get("E1013") + "(UserID=" + uid + ")";
            sLog.error((Object)errMsg);
            throw new ConnectionFailedException(errMsg);
        }
        SimpleSession session = new SimpleSession(user);
        String sid = "";
        try {
            sid = session.getID();
        }
        catch (WorkflowException e) {
            String errMsg = StringManager.get("E1014") + "(UserID=" + uid + ")";
            sLog.error((Object)errMsg);
            throw new ConnectionFailedException(errMsg, e);
        }
        this.sessions.put(sid, session);
        return sid;
    }

    public void validateSession(String sid) throws InvalidSessionException {
        Session session = (Session)this.sessions.get(sid);
        if (session == null) {
            String errMsg = StringManager.get("E1015") + "(SessionID=" + sid + ")";
            sLog.error((Object)errMsg);
            throw new InvalidSessionException(errMsg);
        }
        try {
            session.getID();
        }
        catch (WorkflowException e) {
            String errMsg = StringManager.get("E1017") + "(SessionID=" + sid + ")";
            sLog.error((Object)errMsg);
            throw new InvalidSessionException(errMsg, e);
        }
    }

    public void invalidateSession(String sid) throws InvalidSessionException {
        Session session = (Session)this.sessions.get(sid);
        if (session == null) {
            String errMsg = StringManager.get("E1015") + "(SessionID=" + sid + ")";
            throw new InvalidSessionException(errMsg);
        }
        this.sessions.remove(sid);
        session = null;
    }

    public User getSessionUser(String sid) throws InvalidSessionException {
        Session session = (Session)this.sessions.get(sid);
        if (session == null) {
            String errMsg = StringManager.get("E1015") + "(SessionID=" + sid + ")";
            sLog.error((Object)errMsg);
            throw new InvalidSessionException(errMsg);
        }
        try {
            User user = session.getUser();
            return user;
        }
        catch (WorkflowException e) {
            String errMsg = StringManager.get("E1010") + "(SessionID=" + sid + ")";
            sLog.error((Object)errMsg);
            throw new InvalidSessionException(errMsg, e);
        }
    }

    private void timerRaised() {
        HashSet<String> timeouts = new HashSet<String>();
        Iterator iter = this.sessions.keySet().iterator();
        while (iter.hasNext()) {
            String sid = (String)iter.next();
            Session session = (Session)this.sessions.get(sid);
            try {
                long notAccessedTerm = System.currentTimeMillis() - session.getLastAccessedTime().getTime();
                if (notAccessedTerm < 1800000L) continue;
                timeouts.add(sid);
            }
            catch (WorkflowException e) {
                String warnMsg = StringManager.get("E1016");
                sLog.error((Object)warnMsg, (Throwable)e);
            }
        }
        Iterator timeoutIter = timeouts.iterator();
        while (timeoutIter.hasNext()) {
            String timeoutSID = (String)timeoutIter.next();
            try {
                this.invalidateSession(timeoutSID);
            }
            catch (InvalidSessionException e) {
                sLog.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private SimpleSessionManager ssm;

        TimeoutTimerTask(SimpleSessionManager ssm) {
            this.ssm = ssm;
        }

        public void run() {
            this.ssm.timerRaised();
        }
    }
}

