/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.util;

import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import org.apache.log4j.Logger;

public class FilterHelper {
    private static Logger eLog = LogManager.getEngineLogger();

    public static WorkItemState[] getWorkItemState(Filter filter) throws InvalidFilterException {
        ArrayList list = new ArrayList();
        FilterHelper.parseWorkItemState(list, filter);
        return list.toArray(new WorkItemState[list.size()]);
    }

    private static void parseWorkItemState(List list, Filter filter) throws InvalidFilterException {
        if (filter != null) {
            if (filter instanceof StateFilter) {
                FilterHelper.parseWorkItemState(list, (StateFilter)filter);
            } else if (filter instanceof GroupFilter) {
                FilterHelper.parseWorkItemState(list, (GroupFilter)filter);
            } else {
                String errMsg = StringManager.get("E0037");
                eLog.error((Object)errMsg);
                throw new InvalidFilterException(errMsg);
            }
        }
    }

    private static void parseWorkItemState(List list, StateFilter filter) throws InvalidFilterException {
        WfState state = filter.getState();
        if (!(state instanceof WorkItemState)) {
            String errMsg = StringManager.get("E0038");
            eLog.error((Object)errMsg);
            throw new InvalidFilterException(errMsg);
        }
        list.add(state);
    }

    private static void parseWorkItemState(List list, GroupFilter filter) throws InvalidFilterException {
        Filter[] children = filter.getChild();
        for (int i = 0; i < children.length; ++i) {
            FilterHelper.parseWorkItemState(list, children[i]);
        }
    }
}

