/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

public final class ProcessDefinitionState
implements WfState {
    private static final long serialVersionUID = 20050000000000001L;
    public static final ProcessDefinitionState ENABLE = new ProcessDefinitionState("enable", 1001);
    public static final ProcessDefinitionState DISABLE = new ProcessDefinitionState("disable", 1002);
    private String stateString;
    private int stateNum;

    public static ProcessDefinitionState getState(int n) {
        switch (n) {
            case 1001: {
                return ENABLE;
            }
            case 1002: {
                return DISABLE;
            }
        }
        return null;
    }

    public static ProcessDefinitionState[] getTransitableStates(int n) {
        ArrayList<ProcessDefinitionState> states = new ArrayList<ProcessDefinitionState>();
        switch (n) {
            case 1001: {
                states.add(DISABLE);
                break;
            }
            case 1002: {
                states.add(ENABLE);
            }
        }
        return states.toArray(new ProcessDefinitionState[0]);
    }

    public static void checkTransition(ProcessDefinitionState src, ProcessDefinitionState dest) throws TransitionNotAllowedException {
        if (src.equals(ENABLE)) {
            if (!dest.equals(DISABLE)) {
                String errMsg = StringManager.get("E0050") + "(SourceState=" + src + ", DestinationState=" + dest + ")";
                throw new TransitionNotAllowedException(errMsg);
            }
        } else if (src.equals(DISABLE)) {
            if (!dest.equals(ENABLE)) {
                String errMsg = StringManager.get("E0050") + "(SourceState=" + src + ", DestinationState=" + dest + ")";
                throw new TransitionNotAllowedException(errMsg);
            }
        } else {
            String errMsg = StringManager.get("E0050") + "(SourceState=" + src + ", DestinationState=" + dest + ")";
            throw new TransitionNotAllowedException(errMsg);
        }
    }

    private ProcessDefinitionState(String s, int i) {
        this.stateString = s;
        this.stateNum = i;
    }

    public String toString() {
        return this.stateString;
    }

    public int toInt() {
        return this.stateNum;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcessDefinitionState)) {
            return false;
        }
        ProcessDefinitionState s = (ProcessDefinitionState)obj;
        return this.stateNum == s.stateNum && this.stateString.equals(s.stateString);
    }

    public int hashCode() {
        return this.stateString.hashCode();
    }
}

