/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.awt;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;

public class DialogOutputStream
extends ByteArrayOutputStream
implements ActionListener,
KeyListener {
    Frame parent;
    Dialog dialog;
    TextArea textArea;
    Button button;
    int len = 0;
    private static FlowLayout flowLayout = new FlowLayout();
    static int screen_width;
    static int screen_height;

    public DialogOutputStream(Frame parent) {
        this(parent, 32);
    }

    public DialogOutputStream(Frame parent, int size) {
        this(parent, size, false);
    }

    public DialogOutputStream(Frame parent, int size, boolean modal) {
        super(size);
        this.parent = parent;
        this.dialog = new Dialog(parent, "Error", modal);
        this.textArea = new TextArea("", 0, 0, 0);
        this.textArea.setEditable(false);
        this.textArea.setSize(screen_width * 3 / 4, screen_height / 2);
        this.textArea.setBackground(Color.white);
        this.textArea.addKeyListener(this);
        this.dialog.add("Center", this.textArea);
        this.button = new Button("OK");
        this.button.addActionListener(this);
        Panel panel = new Panel();
        panel.setLayout(flowLayout);
        panel.add(this.button);
        this.dialog.add("South", panel);
        ((Component)this.dialog).setSize(screen_width * 3 / 4, screen_height / 2);
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            ((Component)this.dialog).setVisible(false);
            this.reset();
            this.textArea.setText("");
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        ((Component)this.dialog).setVisible(false);
        this.reset();
        this.textArea.setText("");
        this.dialog.getParent().requestFocus();
    }

    public Dimension getSize() {
        return this.dialog.getSize();
    }

    public void setSize(int w, int h) {
        ((Component)this.dialog).setSize(w, h);
    }

    public void toFront() {
        this.dialog.toFront();
    }

    public synchronized void write(int b) {
        ++this.len;
    }

    public synchronized void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.len += len;
    }

    public void flush() {
        if (this.len < 1) {
            return;
        }
        this.textArea.setText(new String(this.toByteArray()));
        Point loc = this.parent.getLocation();
        Dimension sz1 = this.parent.getSize();
        Dimension sz2 = this.dialog.getSize();
        int x = loc.x + (sz1.width - sz2.width) / 2;
        int y = loc.y + (sz1.height - sz2.height) / 2;
        if (x < 0 || y < 0) {
            Dimension d = this.dialog.getToolkit().getScreenSize();
            x = (d.width - sz2.width) / 2;
            y = (d.height - sz2.height) / 2;
        }
        ((Component)this.dialog).setLocation(x, y);
        ((Component)this.dialog).setVisible(true);
        this.dialog.toFront();
        this.len = 0;
    }

    static {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        screen_width = dim.width;
        screen_height = dim.height;
    }
}

