/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.multithread;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.pnuts.multithread.Queue;

public class ThreadPool {
    private Queue tasks = new Queue();
    private Vector workers = new Vector();
    private Stack idleWorkers = new Stack();
    private int maxThreads;
    private int minThreads;
    private long timeout;
    private int taskRequests = 0;
    private int priority = 5;
    private ThreadGroup threadGroup;
    private volatile boolean terminated = false;
    static int worker_id = 0;

    public ThreadPool(int maxThreads) {
        this(maxThreads, 1, -1L);
    }

    public ThreadPool(int maxThreads, int minThreads, long timeout) {
        this.maxThreads = maxThreads;
        this.minThreads = minThreads;
        this.timeout = timeout;
        this.threadGroup = new WorkerThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        this.tasks.enqueue(task);
        if (this.idleWorkers.isEmpty()) {
            int n_workers = this.workers.size();
            if (this.taskRequests == 0 && n_workers < this.maxThreads) {
                WorkerThread th = new WorkerThread();
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    this.workers.addElement(th);
                }
                th.setPriority(this.priority);
                th.setDaemon(true);
                th.start();
            }
        } else {
            WorkerThread th;
            WorkerThread workerThread = th = (WorkerThread)this.idleWorkers.pop();
            synchronized (workerThread) {
                th.notify();
            }
        }
    }

    public synchronized void shutdown() {
        this.terminated = true;
        this.threadGroup.interrupt();
    }

    synchronized void removeWorker(WorkerThread th) {
        this.workers.remove(th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable getTask() {
        try {
            Object object = this;
            synchronized (object) {
                ++this.taskRequests;
            }
            object = (Runnable)this.tasks.dequeue(this.timeout);
            return object;
        }
        catch (InterruptedException e) {
            Runnable runnable = null;
            return runnable;
        }
        finally {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                --this.taskRequests;
            }
        }
    }

    public synchronized void setPriority(int prio) {
        this.priority = prio;
        Enumeration e = this.workers.elements();
        while (e.hasMoreElements()) {
            Thread th = (Thread)e.nextElement();
            th.setPriority(prio);
        }
    }

    class WorkerThread
    extends Thread {
        public WorkerThread() {
            super(ThreadPool.this.threadGroup, "Worker-" + worker_id++);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ThreadPool.this.tasks.isEmpty() || !ThreadPool.this.terminated) {
                Runnable task = ThreadPool.this.getTask();
                if (task == null) {
                    if (ThreadPool.this.terminated) {
                        return;
                    }
                    if (!ThreadPool.this.idleWorkers.isEmpty() && ThreadPool.this.workers.size() > ThreadPool.this.minThreads) {
                        ThreadPool.this.removeWorker(this);
                        return;
                    }
                    ThreadPool.this.idleWorkers.push(this);
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            ThreadPool.this.idleWorkers.remove(this);
                            return;
                        }
                    }
                }
                task.run();
            }
            return;
        }
    }

    static class WorkerThreadGroup
    extends ThreadGroup {
        public WorkerThreadGroup() {
            super("Worker");
        }

        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                System.err.println("Uncaught Exception: " + e + " by " + t);
            }
        }
    }
}

