/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.util;

import org.pnuts.util.Cache;

public class LRUCache
implements Cache {
    private Cell[] cells;
    private int size;
    private Cell head;
    private Cell tail;
    private int count = 0;

    protected LRUCache() {
    }

    public LRUCache(int size) {
        this.cells = new Cell[size];
        this.size = size;
    }

    void update(Cell b) {
        if (b != this.tail) {
            if (b.prev != null) {
                b.prev.next = b.next;
            }
            if (b.next != null) {
                b.next.prev = b.prev;
            }
            this.tail.next = b;
            b.prev = this.tail;
            this.tail = b;
        }
        if (b == this.head) {
            this.head = b.next;
        }
        b.next = null;
    }

    private Cell findCell(Object key) {
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.size;
        Cell b = this.cells[index];
        while (b != null) {
            if (b.key.equals(key)) {
                this.update(b);
                return b;
            }
            b = b.chain;
        }
        return null;
    }

    public Object get(Object key) {
        Cell cell = this.findCell(key);
        if (cell != null) {
            return cell.value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.size;
        Cell b = this.cells[index];
        Cell n = null;
        Object old = null;
        while (b != null) {
            if (b.key.equals(key)) {
                old = b.value;
                b.value = value;
                this.update(b);
                return old;
            }
            b = b.chain;
        }
        if (this.head != null) {
            if (this.count >= this.size) {
                Cell second = this.head.next;
                n = this.head;
                n.prev = this.tail;
                this.tail.next = n;
                n.next = null;
                n.key = key;
                n.value = value;
                if (n.index == index) {
                    if (n != this.cells[index]) {
                        Cell x = this.cells[index];
                        while (true) {
                            if (x.chain == null) {
                                throw new RuntimeException("[BUG] Reused cell must be found in the chain of index=" + index);
                            }
                            if (x.chain == n) break;
                            x = x.chain;
                        }
                        x.chain = n.chain;
                        n.chain = this.cells[index];
                        this.cells[index] = n;
                    }
                } else {
                    Cell t = this.cells[n.index];
                    if (t == n) {
                        this.cells[n.index] = n.chain;
                    } else {
                        while (t != null && t.chain != null) {
                            if (t.chain == n) {
                                t.chain = n.chain;
                                break;
                            }
                            t = t.chain;
                        }
                    }
                    n.chain = this.cells[index];
                    this.cells[index] = n;
                }
                n.index = index;
                this.head = second;
                this.tail = n;
            } else {
                ++this.count;
                this.cells[index] = n = new Cell(index, this.tail, this.cells[index], key, value);
                this.tail.next = n;
                this.tail = n;
            }
        } else {
            ++this.count;
            n.prev = n = new Cell(index, null, this.cells[index], key, value);
            n.next = n;
            this.cells[index] = n;
            this.head = n;
            this.tail = n;
        }
        return old;
    }

    public void reset() {
        this.tail = null;
        this.head = null;
        this.cells = new Cell[this.size];
        this.count = 0;
    }

    static class Cell {
        Cell next;
        Cell prev;
        Cell chain;
        Object key;
        Object value;
        int index;

        Cell(int index, Cell prev, Cell chain, Object key, Object value) {
            this.index = index;
            this.prev = prev;
            this.chain = chain;
            this.key = key;
            this.value = value;
        }
    }
}

