/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

class CodeLoader
extends ClassLoader {
    private static final boolean DEBUG = false;
    private int count = 0;
    private ProtectionDomain domain;

    CodeLoader() {
        this.init();
    }

    CodeLoader(ClassLoader loader) {
        super(loader);
        this.init();
    }

    void init() {
        this.domain = this.getClass().getProtectionDomain();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        ClassLoader parent = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CodeLoader.this.getParent();
            }
        });
        try {
            if (parent != null) {
                return parent.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.findSystemClass(name);
    }

    void resolve(Class c) {
        this.resolveClass(c);
    }

    Class define(final String name, final byte[] data, final int offset, final int length) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CodeLoader.this.defineClass(name, data, offset, length, CodeLoader.this.domain);
            }
        });
    }

    synchronized int nextCount() {
        return this.count++;
    }
}

