/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.pnuts.util.Stack;
import pnuts.compiler.ClassFile;
import pnuts.compiler.CodeLoader;
import pnuts.compiler.Frame;
import pnuts.compiler.Label;
import pnuts.compiler.Reference;
import pnuts.compiler.Symbol;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;

class CompileContext
extends Context {
    private static final boolean DEBUG = false;
    Frame env = new Frame();
    Symbol sym = new Symbol();
    Hashtable constants = new Hashtable();
    ClassFile cf;
    Vector classFiles = new Vector();
    String constClassName;
    Vector classes = new Vector();
    int line = -1;
    Label returnLabel;
    int contextIndex = 0;
    Stack continueLabelStack = new Stack();
    Stack breakLabelStack = new Stack();

    CompileContext() {
    }

    Class loadClasses(CodeLoader loader) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Class ret = this.load(this.cf, loader, bout);
        Enumeration e = this.classFiles.elements();
        while (e.hasMoreElements()) {
            this.load((ClassFile)e.nextElement(), loader, bout);
        }
        this.resolve(loader);
        return ret;
    }

    void resolve(CodeLoader loader) {
        Enumeration e = this.classes.elements();
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            loader.resolve(c);
        }
    }

    Class load(ClassFile file, CodeLoader loader) throws IOException {
        return this.load(file, loader, new ByteArrayOutputStream());
    }

    Class load(ClassFile file, CodeLoader loader, ByteArrayOutputStream bout) throws IOException {
        bout.reset();
        file.write(new DataOutputStream(bout));
        byte[] array = bout.toByteArray();
        Class ret = loader.define(file.getClassName(), array, 0, array.length);
        this.classes.addElement(ret);
        return ret;
    }

    public ClassFile getClassFile() {
        return this.cf;
    }

    public Enumeration getClassFiles() {
        return this.classFiles.elements();
    }

    public void write(DataOutputStream out) throws IOException {
        this.cf.write(out);
    }

    void debug(ClassFile file) {
        try {
            String fileName = "/tmp/" + file.getClassName() + ".class";
            System.out.println(fileName);
            FileOutputStream fout = new FileOutputStream(fileName);
            DataOutputStream dout = new DataOutputStream(fout);
            file.write(dout);
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void debug() {
        this.debug(this.cf);
        Enumeration e = this.classFiles.elements();
        while (e.hasMoreElements()) {
            ClassFile file = (ClassFile)e.nextElement();
            this.debug(file);
        }
    }

    void _openFrame(String func, String[] locals, boolean leaf) {
        this.env = new Frame(locals, func, this.env, leaf);
    }

    void _closeFrame() {
        this.env = this.env.parent;
    }

    void openScope(String[] locals) {
        this.env.openLocal();
        for (int i = 0; i < locals.length; ++i) {
            this._declare(locals[i]);
        }
    }

    void closeScope() {
        this.env.closeLocal();
    }

    void setReference(String symbol) {
        String sym = symbol.intern();
        Frame f = this.env;
        f.setReference(sym);
    }

    Reference getReference(String symbol) {
        Frame f = this.env;
        String sym = symbol.intern();
        Reference ref = f.getReference(sym);
        if (ref != null) {
            return ref;
        }
        f = f.parent;
        while (f != null) {
            Reference r = f.getReference(sym);
            if (r != null) {
                Frame f0 = this.env;
                Frame f1 = null;
                while (f0 != f) {
                    f1 = f0;
                    if (!f0.imports.contains(sym)) {
                        f0.imports.addElement(sym);
                    }
                    f0 = f0.parent;
                }
                Reference ret = new Reference(sym, -1, r.offset >= 0 ? r.offset : 0);
                Reference _ref = f.getReference(sym);
                Vector<Reference> vec = (Vector<Reference>)f.exports.get(f1);
                if (vec == null) {
                    vec = new Vector<Reference>();
                    f.exports.put(f1, vec);
                }
                if (!vec.contains(_ref)) {
                    vec.addElement(_ref);
                }
                f0 = this.env;
                while (f0 != f1) {
                    Frame p = f0.parent;
                    vec = (Vector<Reference>)p.exports.get(f0);
                    if (vec == null) {
                        vec = new Vector<Reference>();
                        p.exports.put(f0, vec);
                    }
                    if (!vec.contains(ret)) {
                        vec.addElement(ret);
                    }
                    f0 = p;
                }
                return ret;
            }
            f = f.parent;
        }
        return null;
    }

    int _declare(String symbol) {
        int local = this.cf.getLocal();
        this._declare(symbol, local);
        return local;
    }

    void _declare(String symbol, int local) {
        this._declare(symbol, local, this.env.leaf ? -1 : 0);
    }

    void _declare(String symbol, int local, int idx) {
        this.env._declare(symbol, local, idx);
    }

    int declare(String symbol) {
        int local = this.cf.declareLocal();
        this.declare(symbol, local);
        return local;
    }

    void declare(String symbol, int local) {
        this.declare(symbol, local, this.env.leaf ? -1 : 0);
    }

    void declare(String symbol, int local, int idx) {
        this.env.declare(symbol, local, idx);
    }

    int getContextIndex() {
        return this.contextIndex;
    }

    void setContextIndex(int index) {
        this.contextIndex = index;
    }

    Label getContinueLabel() {
        if (this.continueLabelStack.size() < 1) {
            return null;
        }
        return (Label)this.continueLabelStack.peek();
    }

    void pushContinueLabel(Label label) {
        this.continueLabelStack.push(label);
    }

    Label popContinueLabel() {
        return (Label)this.continueLabelStack.pop();
    }

    Label getBreakLabel() {
        if (this.breakLabelStack.size() < 1) {
            return null;
        }
        return (Label)this.breakLabelStack.peek();
    }

    void pushBreakLabel(Label label) {
        this.breakLabelStack.push(label);
    }

    Label popBreakLabel() {
        return (Label)this.breakLabelStack.pop();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable t) {
            throw new PnutsException(t, (Context)this);
        }
    }
}

