/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import pnuts.compiler.ClassFile;
import pnuts.compiler.CodeLoader;
import pnuts.compiler.DynamicProxy;
import pnuts.lang.Pnuts;

public final class DynamicProxyFactory {
    private static final boolean DEBUG = false;
    static Hashtable prim_wrapper_table = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Object;

    private static String wrapperClass(Class returnType) {
        return (String)prim_wrapper_table.get(returnType);
    }

    private static void loadParam(ClassFile cf, Class[] paramTypes, int index) {
        int i;
        int nargs = paramTypes.length;
        if (nargs == 0) {
            return;
        }
        int n = nargs;
        if (nargs > 6) {
            n = 6;
        }
        for (i = 0; i < n; ++i) {
            cf.add((byte)(42 + index));
            cf.add((byte)(3 + i));
            cf.add((byte)50);
            if (paramTypes[i] == (class$java$lang$Object == null ? DynamicProxyFactory.class$("java.lang.Object") : class$java$lang$Object)) continue;
            DynamicProxyFactory.castParam(cf, paramTypes[i]);
        }
        while (i < nargs) {
            cf.add((byte)(42 + index));
            cf.add((byte)16, i);
            cf.add((byte)50);
            if (paramTypes[i] != (class$java$lang$Object == null ? DynamicProxyFactory.class$("java.lang.Object") : class$java$lang$Object)) {
                DynamicProxyFactory.castParam(cf, paramTypes[i]);
            }
            ++i;
        }
    }

    public static byte byte_cast(Object param) {
        if (param instanceof Character) {
            return (byte)((Character)param).charValue();
        }
        if (param instanceof Number) {
            return ((Number)param).byteValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    public static int int_cast(Object param) {
        if (param instanceof Character) {
            return ((Character)param).charValue();
        }
        if (param instanceof Number) {
            return ((Number)param).intValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    public static short short_cast(Object param) {
        if (param instanceof Character) {
            return (short)((Character)param).charValue();
        }
        if (param instanceof Number) {
            return ((Number)param).shortValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    public static char char_cast(Object param) {
        if (param instanceof Character) {
            return ((Character)param).charValue();
        }
        if (param instanceof Number) {
            return (char)((Number)param).intValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    public static long long_cast(Object param) {
        if (param instanceof Character) {
            return ((Character)param).charValue();
        }
        if (param instanceof Number) {
            return ((Number)param).longValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    public static float float_cast(Object param) {
        if (param instanceof Character) {
            return ((Character)param).charValue();
        }
        if (param instanceof Number) {
            return ((Number)param).floatValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    public static double double_cast(Object param) {
        if (param instanceof Character) {
            return ((Character)param).charValue();
        }
        if (param instanceof Number) {
            return ((Number)param).doubleValue();
        }
        throw new ClassCastException(Pnuts.format(param));
    }

    private static void castParam(ClassFile cf, Class paramType) {
        if (paramType == Integer.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "int_cast", "(Ljava/lang/Object;)", "I");
        } else if (paramType == Byte.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "byte_cast", "(Ljava/lang/Object;)", "B");
        } else if (paramType == Short.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "short_cast", "(Ljava/lang/Object;)", "S");
        } else if (paramType == Character.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "char_cast", "(Ljava/lang/Object;)", "C");
        } else if (paramType == Long.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "long_cast", "(Ljava/lang/Object;)", "J");
        } else if (paramType == Float.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "float_cast", "(Ljava/lang/Object;)", "F");
        } else if (paramType == Double.TYPE) {
            cf.add((byte)-72, "pnuts.compiler.DynamicProxyFactory", "double_cast", "(Ljava/lang/Object;)", "D");
        } else if (paramType == Boolean.TYPE) {
            String wrapper = "java.lang.Boolean";
            cf.add((byte)-64, wrapper);
            cf.add((byte)-74, wrapper, "booleanValue", "()", "Z");
        } else {
            cf.add((byte)-64, paramType.getName());
        }
    }

    static DynamicProxy makeProxy(Method method, CodeLoader loader) {
        return DynamicProxyFactory.makeProxy(method.getName(), method.getDeclaringClass(), method.getReturnType(), method.getParameterTypes(), Modifier.isStatic(method.getModifiers()) ? 1 : 0, loader);
    }

    static DynamicProxy makeProxy(Constructor cons, CodeLoader loader) {
        return DynamicProxyFactory.makeProxy("<init>", cons.getDeclaringClass(), Void.TYPE, cons.getParameterTypes(), 2, loader);
    }

    static DynamicProxy makeProxy(String methodName, Class declaringClass, Class returnType, Class[] paramTypes, int type, CodeLoader loader) {
        boolean prim = returnType.isPrimitive() && returnType != Void.TYPE;
        String tempClassName = "_" + (loader.nextCount() & Integer.MAX_VALUE);
        ClassFile cf = new ClassFile(tempClassName, "pnuts.compiler.DynamicProxy", null, 17);
        cf.openMethod("<init>", "()V", (short)1);
        cf.add((byte)42);
        cf.add((byte)-73, "pnuts.compiler.DynamicProxy", "<init>", "()", "V");
        cf.add((byte)-79);
        cf.closeMethod();
        int nargs = paramTypes.length;
        String sig = null;
        if (nargs == 0) {
            sig = "(Ljava/lang/Object;";
            sig = sig + ")Ljava/lang/Object;";
        } else {
            sig = "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
        }
        cf.openMethod("invoke", sig, (short)1);
        String className = declaringClass.getName();
        if (type == 2) {
            cf.add((byte)-69, className);
            cf.add((byte)89);
        } else if (prim) {
            cf.add((byte)-69, DynamicProxyFactory.wrapperClass(returnType));
            cf.add((byte)89);
        }
        if (type == 0) {
            cf.add((byte)43);
            if (declaringClass != (class$java$lang$Object == null ? (class$java$lang$Object = DynamicProxyFactory.class$("java.lang.Object")) : class$java$lang$Object)) {
                cf.add((byte)-64, className);
            }
        }
        if (paramTypes != null && paramTypes.length > 0) {
            DynamicProxyFactory.loadParam(cf, paramTypes, 2);
        }
        if (type == 1) {
            cf.add((byte)-72, className, methodName, ClassFile.signature(paramTypes), ClassFile.signature(returnType));
        } else if (type == 0) {
            if (declaringClass.isInterface()) {
                cf.add((byte)-71, className, methodName, ClassFile.signature(paramTypes), ClassFile.signature(returnType));
            } else {
                cf.add((byte)-74, className, methodName, ClassFile.signature(paramTypes), ClassFile.signature(returnType));
            }
        } else if (type == 2) {
            cf.add((byte)-73, className, methodName, ClassFile.signature(paramTypes), ClassFile.signature(returnType));
        }
        if (prim) {
            cf.add((byte)-73, DynamicProxyFactory.wrapperClass(returnType), "<init>", "(" + ClassFile.signature(returnType) + ")", "V");
        }
        if (type != 2 && returnType == Void.TYPE) {
            cf.add((byte)1);
        }
        cf.add((byte)-80);
        cf.closeMethod();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            cf.write(dout);
            Class clazz = loader.define(tempClassName, bout.toByteArray(), 0, bout.size());
            loader.resolve(clazz);
            return (DynamicProxy)clazz.newInstance();
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        prim_wrapper_table.put(Integer.TYPE, "java.lang.Integer");
        prim_wrapper_table.put(Short.TYPE, "java.lang.Short");
        prim_wrapper_table.put(Long.TYPE, "java.lang.Long");
        prim_wrapper_table.put(Character.TYPE, "java.lang.Character");
        prim_wrapper_table.put(Byte.TYPE, "java.lang.Byte");
        prim_wrapper_table.put(Float.TYPE, "java.lang.Float");
        prim_wrapper_table.put(Double.TYPE, "java.lang.Double");
        prim_wrapper_table.put(Boolean.TYPE, "java.lang.Boolean");
    }
}

