/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassFileHandler;

public class FileWriterHandler
implements ClassFileHandler {
    private static final boolean DEBUG = false;
    private File dir;
    private boolean verbose;

    public FileWriterHandler(File dir) {
        this.dir = dir;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    protected void handleException(Exception e) {
        e.printStackTrace();
    }

    public Object handle(ClassFile cf) {
        try {
            this.write(cf, this.dir);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return null;
    }

    void write(ClassFile cf, File base) throws IOException {
        String className = cf.getClassName();
        int idx = className.lastIndexOf(46);
        File file = null;
        if (idx > 0) {
            String dirname = className.substring(0, idx).replace('.', File.separatorChar);
            File d = new File(base, dirname);
            d.mkdirs();
            file = new File(d, className.substring(idx + 1) + ".class");
        } else {
            file = new File(base, className + ".class");
        }
        FileOutputStream fin = new FileOutputStream(file);
        DataOutputStream dout = new DataOutputStream(fin);
        cf.write(dout);
        dout.close();
        if (this.verbose) {
            System.out.println(file);
        }
    }
}

