/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.pnuts.util.Cache;
import org.pnuts.util.LRUCache;
import org.pnuts.util.MemoryCache;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;

public class CachedPnutsImpl
extends PnutsImpl {
    private static final boolean DEBUG = false;
    private static final boolean java2 = Pnuts.isJava2();
    private boolean useCompiler;
    private boolean useDynamicProxy;
    private boolean includeLineNo;
    private Cache file_cache;

    public CachedPnutsImpl() {
        this(true);
    }

    public CachedPnutsImpl(boolean useCompiler) {
        this(useCompiler, true, false);
    }

    public CachedPnutsImpl(boolean useCompiler, boolean useDynamicProxy, boolean includeLineNo) {
        this(useCompiler, useDynamicProxy, includeLineNo, CachedPnutsImpl.createCache());
    }

    public CachedPnutsImpl(boolean useCompiler, boolean useDynamicProxy, boolean includeLineNo, Cache cache) {
        this.useCompiler = useCompiler;
        this.useDynamicProxy = useDynamicProxy;
        this.includeLineNo = includeLineNo;
        this.file_cache = cache;
    }

    public void includeLineNo(boolean flag) {
        this.includeLineNo = flag;
    }

    protected static Cache createCache() {
        if (java2) {
            return new MemoryCache();
        }
        return new LRUCache(64);
    }

    public void reset() {
        this.file_cache.reset();
    }

    protected ScriptCacheEntry getCachedCode(Object key) {
        return (ScriptCacheEntry)this.file_cache.get(key);
    }

    protected void putCachedCode(Object key, ScriptCacheEntry entry) {
        this.file_cache.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object load(URL scriptURL, Context context) {
        Object conn;
        String protocol = scriptURL.getProtocol();
        Pnuts parsed = null;
        ScriptCacheEntry entry = null;
        InputStream in = null;
        Object reader = null;
        try {
            block25: {
                block24: {
                    if (!"file".equals(protocol)) break block24;
                    String fileName = scriptURL.getFile();
                    File file = new File(fileName);
                    String canon = file.getCanonicalPath();
                    long lastModified = file.lastModified();
                    entry = this.getCachedCode(canon);
                    if (entry == null || lastModified == 0L || entry.lastModified < lastModified) {
                        in = new FileInputStream(file);
                        parsed = Pnuts.parse(Runtime.getScriptReader(in, context), scriptURL, context);
                        if (this.useCompiler) {
                            Compiler compiler = new Compiler(null, false, this.useDynamicProxy);
                            compiler.includeLineNo(this.includeLineNo);
                            try {
                                parsed = compiler.compile(parsed, context);
                            }
                            catch (ClassFormatError cfe) {
                                // empty catch block
                            }
                        }
                        if (lastModified != 0L) {
                            entry = new ScriptCacheEntry();
                            entry.lastModified = lastModified;
                            entry.parsedExpression = parsed;
                            this.putCachedCode(canon, entry);
                        }
                        break block25;
                    } else {
                        parsed = entry.parsedExpression;
                    }
                    break block25;
                }
                conn = scriptURL.openConnection();
                long lastModified = ((URLConnection)conn).getLastModified();
                entry = this.getCachedCode(scriptURL);
                if (entry == null || lastModified == 0L || entry.lastModified < lastModified) {
                    in = ((URLConnection)conn).getInputStream();
                    parsed = Pnuts.parse(Runtime.getScriptReader(in, context), scriptURL, context);
                    if (this.useCompiler) {
                        Compiler compiler = new Compiler(null, false, this.useDynamicProxy);
                        compiler.includeLineNo(this.includeLineNo);
                        try {
                            parsed = compiler.compile(parsed, context);
                        }
                        catch (ClassFormatError cfe) {
                            // empty catch block
                        }
                    }
                    if (lastModified != 0L) {
                        entry = new ScriptCacheEntry();
                        entry.lastModified = lastModified;
                        entry.parsedExpression = parsed;
                        this.putCachedCode(scriptURL, entry);
                    }
                } else {
                    parsed = entry.parsedExpression;
                }
            }
            conn = parsed.run(context);
            if (in == null) return conn;
        }
        catch (Throwable t) {
            try {
                this.checkException(context, t);
                Object var9_13 = null;
                return var9_13;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException io) {}
                }
            }
        }
        try {
            in.close();
            return conn;
        }
        catch (IOException io) {
            // empty catch block
        }
        return conn;
    }

    public static class ScriptCacheEntry {
        public long lastModified;
        public Pnuts parsedExpression;
    }
}

