/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import pnuts.lang.Context;
import pnuts.lang.SimpleNode;
import pnuts.lang.Visitor;

public class UnparseVisitor
implements Visitor {
    private boolean escape;
    private static String indent = " ";
    private int nest = 0;

    public UnparseVisitor() {
        this(false);
    }

    public UnparseVisitor(boolean escape) {
        this.escape = escape;
    }

    String operand(SimpleNode node, int idx) {
        int id = node.jjtGetChild((int)idx).id;
        if (id == 5 || id == 17 || id == 16 || id == 11 || id == 13 || id == 14 || id == 10 || id == 12 || id == 62 || id == 18 || id == 19 || id == 20 || id == 21 || id == 22 || id == 23 || id == 24) {
            return this.accept(node, idx);
        }
        return "(" + this.accept(node, idx) + ")";
    }

    String binary(SimpleNode node, String operator) {
        String a1 = this.operand(node, 0);
        String a2 = this.operand(node, 1);
        return a1 + " " + operator + " " + a2;
    }

    public Object startSet(SimpleNode node, Context context) {
        return this.expressionList(node, context, '\n');
    }

    public Object start(SimpleNode node, Context context) {
        return node.jjtGetChild(0).accept(this, context);
    }

    public Object expressionList(SimpleNode node, Context context) {
        return this.expressionList(node, context, ';');
    }

    public Object expressionList(SimpleNode node, Context context, char delimiter) {
        int num = node.jjtGetNumChildren();
        StringBuffer buf = new StringBuffer();
        if (num > 0) {
            buf.append(this.accept(node, 0));
            for (int i = 1; i < num; ++i) {
                buf.append(delimiter);
                buf.append(this.accept(node, i));
            }
        }
        return buf.toString();
    }

    public Object idNode(SimpleNode node, Context context) {
        int dim = node.jjtGetNumChildren();
        String s = node.str;
        for (int i = 0; i < dim; ++i) {
            s = s + "[]";
        }
        return s;
    }

    public Object global(SimpleNode node, Context context) {
        return "::" + node.str;
    }

    public Object arrayType(SimpleNode node, Context context) {
        return this.accept(node, 0) + "[]";
    }

    public Object listElements(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        String s = "[";
        if (n > 0) {
            s = s + this.accept(node, 0);
            for (int i = 1; i < n; ++i) {
                s = s + ", " + this.accept(node, i);
            }
        }
        return s + "]";
    }

    public Object castExpression(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        String type = this.accept(node, 0);
        if (n == 2) {
            SimpleNode target = node.jjtGetChild(1);
            String s = (String)target.accept(this, context);
            int id = target.id;
            if (id == 5 || id == 17 || id == 16 || id == 11 || id == 13 || id == 14 || id == 10 || id == 12 || id == 62 || id == 18 || id == 19 || id == 20 || id == 21 || id == 22 || id == 23 || id == 24) {
                return "(" + type + ")" + s;
            }
            return "(" + type + ")(" + s + ")";
        }
        return type;
    }

    public Object classNode(SimpleNode node, Context context) {
        int i;
        int n = node.jjtGetNumChildren();
        String s = "class";
        if (node.str != null) {
            s = s + " " + node.str;
        }
        int dim = 0;
        for (i = 0; i < n; ++i) {
            SimpleNode ch = node.jjtGetChild(i);
            if (ch.id == 9) {
                s = s + ".";
                s = s + ch.str;
                continue;
            }
            if (ch.id != 15) continue;
            ++dim;
        }
        for (i = 0; i < dim; ++i) {
            s = s + "[]";
        }
        return s;
    }

    public Object rangeNode(SimpleNode node, Context context) {
        if (node.jjtGetNumChildren() == 3) {
            return this.accept(node, 0) + "[" + this.accept(node, 1) + ".." + this.accept(node, 2) + "]";
        }
        return this.accept(node, 0) + "[" + this.accept(node, 1) + "..]";
    }

    public Object indexNode(SimpleNode node, Context context) {
        return this.accept(node, 0) + "[" + this.accept(node, 1) + "]";
    }

    public Object methodNode(SimpleNode node, Context context) {
        String target = this.accept(node, 0);
        int id = node.jjtGetChild((int)0).id;
        if (id == 18 || id == 19) {
            target = "(" + target + ")";
        }
        String list = this.accept(node, 1);
        return target + "." + node.str + "(" + list.substring(1, list.length() - 1) + ")";
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        String s = this.accept(node, 0) + "::" + node.str;
        String list = this.accept(node, 1);
        return s + "(" + list.substring(1, list.length() - 1) + ")";
    }

    public Object memberNode(SimpleNode node, Context context) {
        String target = this.accept(node, 0);
        int id = node.jjtGetChild((int)0).id;
        if (id == 18 || id == 19) {
            target = "(" + target + ")";
        }
        return target + "." + node.str;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        return this.accept(node, 0) + "::" + node.str;
    }

    public Object applicationNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        String s = this.accept(node, 0) + "(";
        String list = this.accept(node, 1);
        return s + list.substring(1, list.length() - 1) + ")";
    }

    public Object integerNode(SimpleNode node, Context context) {
        return node.str;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        return node.str;
    }

    public Object characterNode(SimpleNode node, Context context) {
        return node.str;
    }

    static String unparseString(String value, boolean escape) {
        StringBuffer b = new StringBuffer();
        if (escape) {
            b.append('\\');
        }
        b.append("\"");
        char[] c = value.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\"') {
                b.append('\\');
                b.append(c[i]);
                continue;
            }
            if (c[i] == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c[i] == '\n') {
                b.append("\\n");
                continue;
            }
            if (c[i] == '\t') {
                b.append("\\t");
                continue;
            }
            if (c[i] == '\r') {
                b.append("\\r");
                continue;
            }
            if (c[i] == '\f') {
                b.append("\\f");
                continue;
            }
            if (c[i] == '\b') {
                b.append("\\b");
                continue;
            }
            if (c[i] == '\u0000') {
                b.append("\\0");
                continue;
            }
            b.append(c[i]);
        }
        if (escape) {
            b.append('\\');
        }
        b.append("\"");
        return b.toString();
    }

    public Object stringNode(SimpleNode node, Context context) {
        return UnparseVisitor.unparseString(node.str, this.escape);
    }

    public Object trueNode(SimpleNode node, Context context) {
        return "true";
    }

    public Object falseNode(SimpleNode node, Context context) {
        return "false";
    }

    public Object nullNode(SimpleNode node, Context context) {
        return "null";
    }

    public Object assignment(SimpleNode node, Context context) {
        return this.binary(node, "=");
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        return this.binary(node, "*=");
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        return this.binary(node, "%=");
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        return this.binary(node, "/=");
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        return this.binary(node, "+=");
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        return this.binary(node, "-=");
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        return this.binary(node, "<<=");
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        return this.binary(node, ">>=");
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        return this.binary(node, ">>>=");
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        return this.binary(node, "&=");
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        return this.binary(node, "^=");
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        return this.binary(node, "|=");
    }

    public Object logAndNode(SimpleNode node, Context context) {
        return this.binary(node, "&&");
    }

    public Object logOrNode(SimpleNode node, Context context) {
        return this.binary(node, "||");
    }

    public Object logNotNode(SimpleNode node, Context context) {
        return "!" + this.operand(node, 0);
    }

    public Object orNode(SimpleNode node, Context context) {
        return this.binary(node, "|");
    }

    public Object xorNode(SimpleNode node, Context context) {
        return this.binary(node, "^");
    }

    public Object andNode(SimpleNode node, Context context) {
        return this.binary(node, "&");
    }

    public Object equalNode(SimpleNode node, Context context) {
        return this.binary(node, "==");
    }

    public Object notEqNode(SimpleNode node, Context context) {
        return this.binary(node, "!=");
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        return this.binary(node, "instanceof");
    }

    public Object ltNode(SimpleNode node, Context context) {
        return this.binary(node, "<");
    }

    public Object gtNode(SimpleNode node, Context context) {
        return this.binary(node, ">");
    }

    public Object leNode(SimpleNode node, Context context) {
        return this.binary(node, "<=");
    }

    public Object geNode(SimpleNode node, Context context) {
        return this.binary(node, ">=");
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        return this.binary(node, "<<");
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        return this.binary(node, ">>");
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        return this.binary(node, ">>>");
    }

    public Object addNode(SimpleNode node, Context context) {
        return this.binary(node, "+");
    }

    public Object subtractNode(SimpleNode node, Context context) {
        return this.binary(node, "-");
    }

    public Object multNode(SimpleNode node, Context context) {
        return this.binary(node, "*");
    }

    public Object divideNode(SimpleNode node, Context context) {
        return this.binary(node, "/");
    }

    public Object modNode(SimpleNode node, Context context) {
        return this.binary(node, "%");
    }

    public Object negativeNode(SimpleNode node, Context context) {
        return "-" + this.operand(node, 0);
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        return "++" + this.operand(node, 0);
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        return "--" + this.operand(node, 0);
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        return this.operand(node, 0) + "++";
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        return this.operand(node, 0) + "--";
    }

    public Object notNode(SimpleNode node, Context context) {
        return "~" + this.operand(node, 0);
    }

    public Object continueNode(SimpleNode node, Context context) {
        return "continue";
    }

    public Object breakNode(SimpleNode node, Context context) {
        if (node.jjtGetNumChildren() > 0) {
            return "break " + this.accept(node, 0);
        }
        return "break";
    }

    public Object returnNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        String s = "return";
        if (n == 1) {
            s = s + " " + this.accept(node, 0);
        }
        return s;
    }

    public Object catchNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            return "catch";
        }
        String s = "catch(";
        String list = this.accept(node, 0);
        return s + list.substring(1, list.length() - 1) + ")";
    }

    public Object blockNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n >= 1) {
            int i;
            String s = null;
            s = this.escape ? "{\\n" : "{\n";
            ++this.nest;
            for (i = 0; i < this.nest; ++i) {
                s = s + indent;
            }
            s = s + this.accept(node, 0);
            for (i = 1; i < n; ++i) {
                s = this.escape ? s + "\\n" : s + "\n";
                for (int j = 0; j < this.nest; ++j) {
                    s = s + indent;
                }
                s = s + this.accept(node, i);
            }
            --this.nest;
            s = this.escape ? s + "\\n" : s + "\n";
            for (i = 0; i < this.nest; ++i) {
                s = s + indent;
            }
            return s + "}";
        }
        return "{}";
    }

    public Object ifStatement(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        String s = "if (" + this.accept(node, 0) + ") " + this.accept(node, 1);
        for (int i = 2; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 70) {
                s = s + " else if (" + this.accept(c, 0) + ") " + this.accept(c, 1);
                continue;
            }
            if (c.id != 71) continue;
            s = s + " else " + this.accept(c, 0);
        }
        return s;
    }

    public Object whileStatement(SimpleNode node, Context context) {
        return "while (" + this.accept(node, 0) + ") " + this.accept(node, 1);
    }

    public Object forStatement(SimpleNode node, Context context) {
        SimpleNode initNode = null;
        SimpleNode condNode = null;
        SimpleNode updateNode = null;
        SimpleNode blockNode = null;
        StringBuffer buf = new StringBuffer("for (");
        int j = 0;
        SimpleNode n = node.jjtGetChild(j);
        if (n.id == 74) {
            buf.append(n.str);
            buf.append(':');
            int nc = n.jjtGetNumChildren();
            buf.append(this.accept(n, 0));
            if (nc == 2) {
                buf.append("..");
                buf.append(this.accept(n, 1));
            }
            buf.append(')');
            ++j;
        } else {
            if (n.id == 75) {
                initNode = n;
                ++j;
            }
            n = node.jjtGetChild(j);
            if (n.id != 76 && n.id != 68) {
                condNode = n;
                ++j;
            }
            n = node.jjtGetChild(j);
            if (n.id == 76) {
                updateNode = n;
                ++j;
            }
            if (initNode != null) {
                int num = initNode.jjtGetNumChildren();
                SimpleNode sn = null;
                if (num > 0) {
                    sn = initNode.jjtGetChild(0);
                    buf.append(sn.str + "=" + this.accept(sn, 0));
                }
                for (int i = 1; i < num; ++i) {
                    sn = initNode.jjtGetChild(i);
                    buf.append("," + sn.str + "=" + this.accept(sn, 0));
                }
            }
            buf.append(';');
            if (condNode != null) {
                buf.append(condNode.accept(this, context));
            }
            buf.append(';');
            if (updateNode != null) {
                buf.append(this.expressionList(updateNode, context, ','));
            }
            buf.append(") ");
        }
        blockNode = node.jjtGetChild(j);
        buf.append(blockNode.accept(this, context));
        return buf.toString();
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        return "foreach " + node.str + " (" + this.accept(node, 0) + ") " + this.accept(node, 1);
    }

    public Object switchStatement(SimpleNode node, Context context) {
        String s = "switch (" + this.accept(node, 0) + "){";
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode n = node.jjtGetChild(i);
            s = n.jjtGetNumChildren() == 1 ? s + "case " + this.accept(n, 0) + ": " + this.accept(node, ++i) : s + "default: " + this.accept(node, ++i);
            s = s + "; ";
        }
        return s + "}";
    }

    public Object switchBlock(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            String s = this.accept(node, 0);
            for (int i = 1; i < n; ++i) {
                s = s + "; " + this.accept(node, i);
            }
            return s;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public Object functionStatement(SimpleNode node, Context context) {
        s = "function ";
        pid = node.jjtGetParent().id;
        if (pid == 14 || pid == 10) {
            s = "(" + s;
        }
        if (node.str != null) {
            s = s + node.str;
        }
        args = node.jjtGetChild(0);
        nargs = args.jjtGetNumChildren();
        s = s + "(";
        n0 = null;
        if (nargs != 1) ** GOTO lbl-1000
        n0 = args.jjtGetChild(0);
        if (n0.id == 17) {
            s = s + n0.jjtGetChild((int)0).str;
            s = s + "[]";
        } else if (nargs > 0) {
            s = s + args.jjtGetChild((int)0).str;
            for (i = 1; i < nargs; ++i) {
                s = s + ", " + args.jjtGetChild((int)i).str;
            }
        }
        s = s + ") " + this.accept(node, 1);
        if (pid == 14 || pid == 10) {
            s = s + ")";
        }
        return s;
    }

    final String accept(SimpleNode node, int idx) {
        return (String)node.jjtGetChild(idx).accept(this, null);
    }
}

