/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.pnuts.util.Stack;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Executable;
import pnuts.lang.Function;
import pnuts.lang.Jump;
import pnuts.lang.Package;
import pnuts.lang.ParseException;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsParser;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.Token;
import pnuts.lang.Visitor;

public class Pnuts
implements Executable,
Serializable {
    static final long serialVersionUID = 7894532250660251865L;
    public static final String pnuts_version = "1.0rc2";
    public static String prompt = "> ";
    static String compiledClassPrefix;
    private static Stack freeParsers;
    private static int java2;
    static Properties defaultSettings;
    protected SimpleNode startNodes = null;
    protected transient Object value;
    protected Object scriptSource;
    static /* synthetic */ Class class$pnuts$lang$Pnuts;

    static String getCompiledClassPrefix() {
        if (compiledClassPrefix == null) {
            try {
                compiledClassPrefix = Runtime.getProperty("pnuts.compiled.script.prefix");
                if (compiledClassPrefix == null) {
                    compiledClassPrefix = "";
                } else if (!"".equals(compiledClassPrefix) && !compiledClassPrefix.endsWith(".")) {
                    compiledClassPrefix = compiledClassPrefix + ".";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return compiledClassPrefix;
    }

    public static final boolean isJava2() {
        if (java2 == 0) {
            try {
                if (Runtime.getProperty("pnuts.jdk11.compatible") != null) {
                    java2 = -1;
                } else {
                    Class.forName("java.lang.Package");
                    java2 = 1;
                }
            }
            catch (Throwable t) {
                java2 = -1;
            }
        }
        return java2 == 1;
    }

    public static void setDefaults(Properties properties) {
        defaultSettings = properties;
    }

    public static Properties getDefaults() {
        return defaultSettings;
    }

    public static final Class loadClass(String name, Context context) throws ClassNotFoundException {
        ClassLoader ccl;
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e1) {
            }
            catch (LinkageError e2) {
                // empty catch block
            }
        }
        if (Pnuts.isJava2() && (ccl = Thread.currentThread().getContextClassLoader()) != null && ccl != classLoader) {
            try {
                return ccl.loadClass(name);
            }
            catch (ClassNotFoundException e1) {
            }
            catch (LinkageError e2) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    public static final URL getResource(String s, Context context) {
        URL url;
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(s)) != null) {
            return url;
        }
        if (Pnuts.isJava2()) {
            URL url2;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null && (url2 = ccl.getResource(s)) != null) {
                return url2;
            }
            return (class$pnuts$lang$Pnuts == null ? (class$pnuts$lang$Pnuts = Pnuts.class$("pnuts.lang.Pnuts")) : class$pnuts$lang$Pnuts).getResource(s);
        }
        return ClassLoader.getSystemResource(s);
    }

    public static void setPrompt(String str) {
        prompt = str;
    }

    public static void setVerbose(boolean b) {
        Context.defaultVerboseMode = b;
    }

    public static boolean isVerbose() {
        return Context.defaultVerboseMode;
    }

    public static String format(Object obj) {
        return Runtime.format(obj, 64);
    }

    public static Object get(String str) {
        return Pnuts.get(str, "");
    }

    public static Object get(String str, String pkg) {
        Package p = Package.find(pkg);
        if (p != null) {
            return p.get(str.intern());
        }
        return null;
    }

    public static void set(String str, Object val) {
        Pnuts.set(str, val, "");
    }

    public static void set(String str, Object val, String pkg) {
        Package p;
        if (str.length() > 0 && Character.isJavaIdentifierStart(str.charAt(0))) {
            p = Package.find(pkg);
            if (p == null) {
                throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "package.notFound", new Object[]{pkg}));
            }
        } else {
            throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "illegal.symbolForId", PnutsException.NO_PARAM));
        }
        p.set(str.intern(), val);
    }

    public static Object eval(String expr, Context context) {
        return context.pnutsImpl.eval(expr, context);
    }

    public static Object loadFile(String file, Context context) throws FileNotFoundException {
        return context.pnutsImpl.loadFile(file, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(String name, Context context) throws FileNotFoundException {
        String file = name;
        if (!name.endsWith(".pnut")) {
            file = name + ".pnut";
            Executable rt = Runtime.getCompiledScript(name, context);
            if (rt != null) {
                if (context.verbose) {
                    System.out.println("[loading " + Pnuts.format(rt.getClass()) + "]");
                }
                int depth = Pnuts.enter(context);
                context.pushFile(rt);
                try {
                    Object ret = rt.run(context);
                    Pnuts.provide(file, context);
                    Object object = ret;
                    return object;
                }
                catch (Jump jump) {
                    Pnuts.provide(file, context);
                    Object object = jump.getValue();
                    return object;
                }
                finally {
                    context.popFile();
                    context.depth = depth;
                }
            }
        }
        return context.pnutsImpl.load(file, context);
    }

    public static Object load(URL url, Context context) {
        return context.pnutsImpl.load(url, context);
    }

    public static Object load(InputStream in, Context context) {
        return Pnuts.load(Runtime.getScriptReader(in, context), context);
    }

    public static Object load(InputStream in, boolean interactive, Context context) {
        return Pnuts.load(Runtime.getScriptReader(in, context), interactive, context);
    }

    public static Object load(Reader reader, Context context) {
        return Pnuts.load(reader, false, context);
    }

    public static Object load(Reader reader, boolean interactive, Context context) {
        return new Pnuts((Reader)reader, (boolean)interactive, (Context)context).value;
    }

    public static Pnuts parse(InputStream in) throws ParseException {
        return Pnuts.parse(new InputStreamReader(in));
    }

    public static Pnuts parse(Reader reader) throws ParseException {
        return new Pnuts(reader);
    }

    public static Pnuts parse(Reader reader, Object scriptSource, Context context) {
        Function frame = context.frame;
        context.frame = null;
        try {
            Pnuts p = new Pnuts(reader);
            p.setScriptSource(scriptSource);
            Pnuts pnuts = p;
            return pnuts;
        }
        catch (ParseException pe) {
            throw new PnutsException(pe, context);
        }
        finally {
            context.frame = frame;
        }
    }

    public static Pnuts parse(String expr) throws ParseException {
        Pnuts p = new Pnuts(new StringReader(expr));
        p.scriptSource = expr;
        return p;
    }

    public String unparse() {
        return Runtime.unparse(this.startNodes, null);
    }

    public void unparse(Writer writer) throws IOException {
        writer.write(this.unparse());
    }

    public static void require(String file, Context context) throws FileNotFoundException {
        if (file.endsWith(".pnut")) {
            file = file.substring(0, file.length() - 5);
        }
        file = file.intern();
        context.require(file);
    }

    static void provide(String file, Context context) {
        if (file.endsWith(".pnut")) {
            file = file.substring(0, file.length() - 5);
        }
        context.provide(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop(PnutsParser parser, boolean interactive, Context context) {
        while (true) {
            try {
                while (true) {
                    PrintWriter term = null;
                    if (interactive) {
                        Pnuts.flush(context);
                        term = context.getTerminalWriter();
                        if (term != null) {
                            term.print(prompt);
                            term.flush();
                        }
                    }
                    SimpleNode start = parser.Start();
                    switch (Pnuts.getCode(start)) {
                        case -1: {
                            ((int[])start.info)[0] = 0;
                            return;
                        }
                        case 0: {
                            Pnuts.reset(parser);
                            break;
                        }
                        case 1: {
                            if (interactive) {
                                try {
                                    this.value = context.pnutsImpl.accept(start, context);
                                }
                                catch (Jump jump) {
                                    this.value = jump.getValue();
                                }
                                finally {
                                    context.onExit(this.value);
                                }
                            } else {
                                this.value = context.pnutsImpl.accept(start, context);
                            }
                            if (Pnuts.getCode(start) == -1) {
                                this.value = start.value;
                                return;
                            }
                            if (interactive && term != null) {
                                try {
                                    term.println(Pnuts.format(this.value));
                                    term.flush();
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (Throwable t) {
                                    Runtime.checkException(context, t);
                                }
                            }
                            Pnuts.reset(parser);
                        }
                    }
                }
            }
            catch (ParseException p) {
                Pnuts.error_skipto(parser, 6);
                if (!interactive || context.depth > 1) {
                    Runtime.checkException(context, p);
                    continue;
                }
                int line = context.beginLine;
                try {
                    context.beginLine = p.currentToken.next.beginLine;
                    Runtime.checkException(context, p);
                }
                catch (Jump j) {
                    this.value = j.getValue();
                    PrintWriter term = context.getTerminalWriter();
                    if (interactive && term != null) {
                        term.println(this.value);
                        term.flush();
                    }
                }
                catch (PnutsException t) {
                    Runtime.printError(t, context);
                }
                finally {
                    context.beginLine = line;
                }
                Pnuts.reset(parser);
                Pnuts.recover(context);
                this.value = null;
                continue;
            }
            catch (Escape esc) {
                Pnuts.reset(parser);
                throw esc;
            }
            catch (Throwable t) {
                if (!interactive || context.depth > 1) {
                    if (t instanceof PnutsException) {
                        throw (PnutsException)t;
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    throw new PnutsException(t, context);
                }
                if (t instanceof ThreadDeath) {
                    return;
                }
                Runtime.printError(t, context);
                Pnuts.reset(parser);
                Pnuts.recover(context);
                this.value = null;
                continue;
            }
            break;
        }
    }

    private static void error_skipto(PnutsParser parser, int kind) {
        Token t;
        while ((t = parser.getNextToken()) != null && t.image.length() > 0 && t.kind != kind) {
        }
    }

    protected Pnuts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pnuts(Reader reader) throws ParseException {
        PnutsParser parser;
        Stack stack = freeParsers;
        synchronized (stack) {
            if (freeParsers.size() > 0) {
                parser = (PnutsParser)freeParsers.pop();
                parser.ReInit(reader);
            } else {
                parser = new PnutsParser(reader);
            }
        }
        try {
            this.startNodes = parser.StartSet();
        }
        catch (ParseException e) {
            Pnuts.error_skipto(parser, 6);
            Pnuts.reset(parser);
            throw e;
        }
        finally {
            Stack stack2 = freeParsers;
            synchronized (stack2) {
                if (freeParsers.size() < 3) {
                    freeParsers.push(parser);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Context context) {
        int depth = Pnuts.enter(context);
        context.pushFile(this.scriptSource);
        Function frame = context.frame;
        context.frame = null;
        try {
            Object value = this.accept(context);
            context.onExit(value);
            Object object = value;
            return object;
        }
        catch (Escape esc) {
            context.onExit(this.value);
            Object object = esc.getValue();
            return object;
        }
        finally {
            context.depth = depth;
            context.frame = frame;
            context.popFile();
        }
    }

    public void setScriptSource(Object src) {
        this.scriptSource = src;
    }

    public Object getScriptSource() {
        return this.scriptSource;
    }

    protected Object accept(Context context) {
        return context.pnutsImpl.accept(this.startNodes, context);
    }

    private static void flush(Context context) {
        PrintWriter out = context.getWriter();
        if (out != null) {
            out.flush();
        }
    }

    public Object accept(Visitor visitor, Context context) {
        int depth = Pnuts.enter(context);
        Object value = null;
        try {
            value = this.startNodes.accept(visitor, context);
            context.onExit(value);
            Object object = value;
            return object;
        }
        catch (Escape esc) {
            context.onExit(value);
            Object val = esc.getValue();
            Pnuts.flush(context);
            Object object = val;
            return object;
        }
        catch (PnutsException pe) {
            context.onError(pe);
            throw pe;
        }
        catch (Throwable t) {
            PnutsException e = new PnutsException(t, context);
            context.onError(e);
            throw e;
        }
        finally {
            context.depth = depth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pnuts(Reader reader, boolean interactive, Context context) {
        PnutsParser parser;
        Object object = freeParsers;
        synchronized (object) {
            if (freeParsers.size() > 0) {
                parser = (PnutsParser)freeParsers.pop();
                parser.ReInit(reader);
            } else {
                parser = new PnutsParser(reader);
            }
        }
        object = context.namespaceRefreshed;
        synchronized (context.namespaceRefreshed) {
            context.namespaceRefreshed[0] = false;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            int depth = 0;
            depth = Pnuts.enter(context);
            try {
                this.loop(parser, interactive, context);
                Pnuts.flush(context);
                context.onExit(this.value);
            }
            catch (Escape esc) {
                context.onExit(this.value);
                this.value = esc.getValue();
                Pnuts.flush(context);
            }
            catch (PnutsException t) {
                if (!interactive || context.depth > 1) {
                    throw t;
                }
                Runtime.printError(t, context);
            }
            finally {
                Executable hook = context.exitHook;
                if (hook != null) {
                    hook.run(context);
                }
                if (!interactive) {
                    context.depth = depth;
                }
                Stack stack = freeParsers;
                synchronized (stack) {
                    if (freeParsers.size() < 3) {
                        freeParsers.push(parser);
                    }
                }
            }
            return;
        }
    }

    static int enter(Context context) {
        int depth;
        if ((depth = context.depth++) < Integer.MAX_VALUE) {
            // empty if block
        }
        return depth;
    }

    public static int evalDepth(Context context) {
        return context.depth;
    }

    private static void reset(PnutsParser parser) {
        parser.jjtree.reset();
    }

    private static void recover(Context context) {
        context.resetStackFrame();
        context.loadingResource = null;
    }

    private static final int getCode(SimpleNode node) {
        return ((int[])node.info)[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        freeParsers = new Stack();
        java2 = 0;
    }
}

