/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import pnuts.lang.Binding;
import pnuts.lang.ImmutableBinding;
import pnuts.lang.NamedValue;

class SymbolTable
implements Cloneable,
Serializable {
    static final int INITIAL_CAPACITY = 8;
    static final float LOAD_FACTOR = 0.75f;
    Binding[] table = new Binding[8];
    int count;
    private int threshold = 6;
    SymbolTable parent;
    static final long serialVersionUID = 7774881842850548306L;

    public SymbolTable() {
    }

    public SymbolTable(SymbolTable parent) {
        this();
        this.parent = parent;
    }

    public synchronized Object get(String interned) {
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        int i = hash & this.table.length - 1;
        Binding b = this.table[i];
        while (b != null) {
            if (interned == b.name) {
                return b.value;
            }
            b = b.chain;
        }
        return b;
    }

    synchronized Binding lookup0(String interned) {
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        int i = hash & this.table.length - 1;
        Binding b = this.table[i];
        while (b != null && interned != b.name) {
            b = b.chain;
        }
        return b;
    }

    public synchronized NamedValue lookup(String interned) {
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        SymbolTable env = this;
        do {
            Binding[] env_tab = env.table;
            int i = hash & env_tab.length - 1;
            Binding b = env_tab[i];
            while (b != null && interned != b.name) {
                b = b.chain;
            }
            if (b == null) continue;
            return b;
        } while ((env = env.parent) != null);
        return null;
    }

    public synchronized void set(String interned, Object value) {
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        int i = hash & this.table.length - 1;
        Binding b = this.table[i];
        while (b != null) {
            if (interned == b.name) {
                b.set(value);
                return;
            }
            b = b.chain;
        }
        this.addBinding(hash, interned, value, i);
    }

    public synchronized void setConstant(String interned, Object value) {
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        int i = hash & this.table.length - 1;
        Binding b = this.table[i];
        while (b != null) {
            if (interned == b.name) {
                if (b instanceof ImmutableBinding) {
                    throw new IllegalStateException();
                }
                this.removeBinding(interned);
            }
            b = b.chain;
        }
        this.addConstant(hash, interned, value, i);
    }

    synchronized void assign(String interned, Object value) {
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        SymbolTable env = this;
        do {
            Binding[] env_tab = env.table;
            int i = hash & env_tab.length - 1;
            Binding b = env_tab[i];
            while (b != null && interned != b.name) {
                b = b.chain;
            }
            if (b == null) continue;
            b.set(value);
            return;
        } while ((env = env.parent) != null);
        this.addBinding(hash, interned, value, hash & this.table.length - 1);
    }

    void addBinding(int hash, String interned, Object value, int index) {
        this.table[index] = new Binding(hash, interned, value, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.ensureCapacity(this.table.length * 2);
        }
    }

    void addConstant(int hash, String interned, Object value, int index) {
        this.table[index] = new ImmutableBinding(hash, interned, value, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.ensureCapacity(this.table.length * 2);
        }
    }

    void ensureCapacity(int newCapacity) {
        Binding[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Binding[] newTable = new Binding[newCapacity];
        Binding[] src = this.table;
        for (int j = 0; j < src.length; ++j) {
            Binding next;
            Binding b = src[j];
            if (b == null) continue;
            src[j] = null;
            do {
                next = b.chain;
                int i = b.hash & newCapacity - 1;
                b.chain = newTable[i];
                newTable[i] = b;
            } while ((b = next) != null);
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * 0.75f);
    }

    Binding removeBinding(String interned) {
        Binding prev;
        int hash = interned.hashCode() & Integer.MAX_VALUE;
        int i = hash & this.table.length - 1;
        Binding b = prev = this.table[i];
        while (b != null) {
            Binding next = b.chain;
            if (interned == b.name) {
                --this.count;
                if (prev == b) {
                    this.table[i] = next;
                } else {
                    prev.chain = next;
                }
                return b;
            }
            prev = b;
            b = next;
        }
        return b;
    }

    public synchronized void clear() {
        Binding[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public Object clone() {
        try {
            SymbolTable copy = (SymbolTable)super.clone();
            Binding[] newTable = new Binding[this.table.length];
            for (int i = 0; i < this.table.length; ++i) {
                Binding b = this.table[i];
                if (b == null) continue;
                newTable[i] = (Binding)b.clone();
            }
            copy.table = newTable;
            if (this.parent != null) {
                copy.parent = (SymbolTable)this.parent.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Enumeration bindings() {
        return new Enumerator(0);
    }

    public Enumeration keys() {
        return new Enumerator(1);
    }

    public Enumeration values() {
        return new Enumerator(2);
    }

    public int hashCode() {
        int code = 0;
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            code ^= key.hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SymbolTable)) {
            return false;
        }
        SymbolTable st = (SymbolTable)obj;
        if (st.size() != this.count) {
            return false;
        }
        Enumeration e = st.bindings();
        while (e.hasMoreElements()) {
            NamedValue n = (NamedValue)e.nextElement();
            if (this.get(n.getName()) == n.get()) continue;
            return false;
        }
        if (this.parent == null) {
            return st.parent == null;
        }
        return this.parent.equals(st.parent);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    private class Enumerator
    implements Enumeration {
        Binding bind = null;
        int index;
        int kind;

        Enumerator(int kind) {
            this.index = SymbolTable.this.table.length;
            this.kind = kind;
        }

        public boolean hasMoreElements() {
            while (this.bind == null && this.index > 0) {
                this.bind = SymbolTable.this.table[--this.index];
            }
            return this.bind != null;
        }

        public Object nextElement() {
            while (this.bind == null && this.index > 0) {
                this.bind = SymbolTable.this.table[--this.index];
            }
            if (this.bind != null) {
                Binding b = this.bind;
                this.bind = b.chain;
                if (this.kind == 0) {
                    return b;
                }
                if (this.kind == 1) {
                    return b.name;
                }
                return b.value;
            }
            throw new NoSuchElementException("SymbolTable Enumerator");
        }
    }
}

