/*
 * Decompiled with CFR 0.152.
 */
package pnuts.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import pnuts.security.PackagePermissionCollection;

public final class PackagePermission
extends BasicPermission {
    private static final int WRITE = 1;
    private static final int ADD = 2;
    private static final int REMOVE = 4;
    private transient int mask = 0;
    private transient String actions;
    private transient boolean wildcard = false;
    private transient String path;

    public PackagePermission(String name) {
        super(name);
    }

    public PackagePermission(String name, String actions) {
        super(name, actions);
        this.actions = actions;
        this.init(actions);
    }

    void init(String actions) {
        String name;
        if (actions.indexOf("write") >= 0) {
            this.mask |= 1;
        }
        if (actions.indexOf("add") >= 0) {
            this.mask |= 2;
        }
        if (actions.indexOf("remove") >= 0) {
            this.mask |= 4;
        }
        if ((name = this.getName()).endsWith("::*")) {
            this.wildcard = true;
            this.path = name.substring(0, name.length() - 2);
        } else if (name.endsWith(".*")) {
            this.wildcard = true;
            this.path = name.substring(0, name.length() - 1);
        } else if (name.equals("*")) {
            this.wildcard = true;
            this.path = "";
            this.path = name.substring(0, name.length() - 2);
        } else {
            this.path = name;
        }
    }

    public String getActions() {
        String s = "";
        boolean first = true;
        if ((this.mask & 1) != 0) {
            s = s + "write";
            first = false;
        }
        if ((this.mask & 2) != 0) {
            if (!first) {
                s = s + ", ";
            }
            s = s + "add";
            first = false;
        }
        if ((this.mask & 4) != 0) {
            if (!first) {
                s = s + ", ";
            }
            s = s + "remove";
        }
        return s;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof PackagePermission)) {
            return false;
        }
        PackagePermission pp = (PackagePermission)p;
        int m = pp.getMask();
        if ((m & this.mask) != m) {
            return false;
        }
        if (this.wildcard) {
            if (pp.wildcard) {
                return pp.path.startsWith(this.path);
            }
            return pp.path.length() > this.path.length() && pp.path.startsWith(this.path);
        }
        if (pp.wildcard) {
            return false;
        }
        return this.path.equals(pp.path);
    }

    int getMask() {
        return this.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new PackagePermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.actions);
    }
}

