/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLTargetProcessDAO
extends AbstractDAO
implements TargetProcessDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String ENGINE_ID = "ENGINE_ID";
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String ROOT_PROC_ID = "ROOT_PROC_ID";
    public static final String ROOT_ACT_ID = "ROOT_ACT_ID";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from ETAPROCESS where ENGINE_ID = ? AND PROCESS_ID = ? ";
    private static final String SQL_SELECT_BY_PROC_ID = "select * from ETAPROCESS where PROCESS_ID = ? ";
    private static final String SQL_SELECT_BY_ROOT_ID = "select * from ETAPROCESS where ROOT_PROC_ID = ? AND ROOT_ACT_ID = ? ";
    private static final String SQL_INSERT = "insert into ETAPROCESS (ENGINE_ID, PROCESS_ID, ROOT_PROC_ID, ROOT_ACT_ID) values (?,?,?,?)";
    private static final String SQL_DELETE = "delete from ETAPROCESS where ENGINE_ID = ? AND PROCESS_ID = ? ";

    MySQLTargetProcessDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetProcessBean findByPrimaryKey(String eid, String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, eid);
            st.setString(2, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            TargetProcessBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            TargetProcessBean targetProcessBean = bean;
            return targetProcessBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetProcessBean findByProcessID(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PROC_ID);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            TargetProcessBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            TargetProcessBean targetProcessBean = bean;
            return targetProcessBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetProcessBean findByRootID(String rootpid, String rootaid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_ROOT_ID);
        try {
            st.setString(1, rootpid);
            st.setString(2, rootaid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            TargetProcessBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            TargetProcessBean targetProcessBean = bean;
            return targetProcessBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(TargetProcessBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getEngineID());
            st.setString(2, bean.getProcessID());
            st.setString(3, bean.getRootProcID());
            st.setString(4, bean.getRootActID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0028");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String eid, String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_DELETE);
        try {
            st.setString(1, eid);
            st.setString(2, pid);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0027");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private TargetProcessBean createBean(ResultSet rs) throws SQLException {
        TargetProcessBean bean = new TargetProcessBean();
        bean.setEngineID(rs.getString(ENGINE_ID));
        bean.setProcessID(rs.getString(PROCESS_ID));
        bean.setRootProcID(rs.getString(ROOT_PROC_ID));
        bean.setRootActID(rs.getString(ROOT_ACT_ID));
        return bean;
    }
}

