/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLVariableDAO
extends AbstractDAO
implements VariableDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String VAR_ID = "VAR_ID";
    public static final String NAME = "NAME";
    public static final String PROC_ID = "PROC_ID";
    public static final String VAR_DEF_ID = "VAR_DEF_ID";
    public static final String TYPE = "TYPE";
    public static final String VALUE = "VALUE";
    public static final String UPDATE_DATE = "UPDATE_DATE";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from VARIABLE where PROC_ID = ? AND VAR_ID = ? ";
    private static final String SQL_SELECT_BY_DEFINITION_ID = "select * from VARIABLE where PROC_ID = ? AND VAR_DEF_ID = ? ";
    private static final String SQL_SELECT_BY_PROCEESS_ID = "select * from VARIABLE where PROC_ID = ? ";
    private static final String SQL_SELECT_BY_PROCEESS_ID_AND_NAME = "select * from VARIABLE where PROC_ID = ? AND NAME = ? ";
    private static final String SQL_INSERT = "insert into VARIABLE (VAR_ID, NAME, PROC_ID, VAR_DEF_ID, TYPE, VALUE, UPDATE_DATE) values (?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE = "update  VARIABLE set VALUE = ?, UPDATE_DATE = ? where PROC_ID = ? AND NAME = ? AND TYPE = ? ";

    MySQLVariableDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableBean findByPrimaryKey(String pid, String vid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, pid);
            st.setString(2, vid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            VariableBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            VariableBean variableBean = bean;
            return variableBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableBean findByDefinitionID(String pid, String vdid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_DEFINITION_ID);
        try {
            st.setString(1, pid);
            st.setString(2, vdid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            VariableBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            VariableBean variableBean = bean;
            return variableBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableBean findByName(String pid, String name) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PROCEESS_ID_AND_NAME);
        try {
            st.setString(1, pid);
            st.setString(2, name);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            VariableBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            VariableBean variableBean = bean;
            return variableBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableBean[] findByProcessID(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PROCEESS_ID);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<VariableBean> beans = new ArrayList<VariableBean>();
            while (rs.next()) {
                VariableBean bean = this.createBean(rs);
                beans.add(bean);
            }
            VariableBean[] variableBeanArray = beans.toArray(new VariableBean[beans.size()]);
            return variableBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByProcessIDAsList(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PROCEESS_ID);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<VariableBean> beans = new ArrayList<VariableBean>();
            while (rs.next()) {
                VariableBean bean = this.createBean(rs);
                beans.add(bean);
            }
            ArrayList<VariableBean> arrayList = beans;
            return arrayList;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableBean[] findBySQLPart(String pid, String sqlPart) throws SQLException, DAOException {
        String sql = SQL_SELECT_BY_PROCEESS_ID;
        if (sqlPart != null && !sqlPart.trim().equals("")) {
            sql = sql + " AND " + sqlPart;
        }
        PreparedStatement st = this.getConnection().prepareStatement(sql);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<VariableBean> beans = new ArrayList<VariableBean>();
            while (rs.next()) {
                VariableBean bean = this.createBean(rs);
                beans.add(bean);
            }
            VariableBean[] variableBeanArray = beans.toArray(new VariableBean[beans.size()]);
            return variableBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(VariableBean bean, String actid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getID());
            st.setString(2, bean.getName());
            st.setString(3, bean.getProcessID());
            st.setString(4, bean.getVariableDefinitionID());
            st.setInt(5, bean.getType());
            st.setString(6, bean.getValue());
            st.setTimestamp(7, bean.getUpdateDate());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0029");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            VariableHistoryDAO ahDAO = factory.getVariableHistoryDAO();
            VariableHistoryBean history = new VariableHistoryBean();
            history.setVarID(bean.getID());
            history.setProcID(bean.getProcessID());
            history.setVarDefID(bean.getVariableDefinitionID());
            history.setType(bean.getType());
            history.setPrevValue(null);
            history.setNewValue(bean.getValue());
            history.setUpdateDate(bean.getUpdateDate());
            history.setReason("NEW VAR CREATION");
            history.setActivityID(actid);
            ahDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0030");
            throw new DAOException(errMsg, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(VariableBean bean, String value, String actid, Timestamp ts) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE);
        try {
            st.setString(1, value);
            st.setTimestamp(2, ts);
            st.setString(3, bean.getProcessID());
            st.setString(4, bean.getName());
            st.setInt(5, bean.getType());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0031");
                throw new DAOException(errMsg);
            }
            bean.setValue(value);
            bean.setUpdateDate(ts);
        }
        finally {
            st.close();
        }
        try {
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            VariableHistoryDAO ahDAO = factory.getVariableHistoryDAO();
            VariableHistoryBean history = new VariableHistoryBean();
            history.setVarID(bean.getID());
            history.setProcID(bean.getProcessID());
            history.setVarDefID(bean.getVariableDefinitionID());
            history.setType(bean.getType());
            history.setPrevValue(null);
            history.setNewValue(bean.getValue());
            history.setUpdateDate(bean.getUpdateDate());
            history.setActivityID(actid);
            String msg = "VARIABLE CHANGED";
            history.setReason(msg);
            ahDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0030");
            throw new DAOException(errMsg, ex);
        }
    }

    private VariableBean createBean(ResultSet rs) throws SQLException {
        VariableBean bean = new VariableBean();
        bean.setID(rs.getString(VAR_ID));
        bean.setName(rs.getString(NAME));
        bean.setProcessID(rs.getString(PROC_ID));
        bean.setVariableDefinitionID(rs.getString(VAR_DEF_ID));
        bean.setType(rs.getInt(TYPE));
        bean.setValue(rs.getString(VALUE));
        bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
        return bean;
    }
}

