/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.expression.Expression;

class ConditionEvaluator {
    ConditionEvaluator() {
    }

    static List evaluate(ProcessDefinition pd, ActivityDefinition ad, List vars, boolean isExRaising) {
        ArrayList<TransitionDefinition> result = new ArrayList<TransitionDefinition>();
        ArrayList<TransitionDefinition> otherwises = new ArrayList<TransitionDefinition>();
        boolean isConcurrent = false;
        if (ad.getType().equals("CONCUR_START")) {
            isConcurrent = true;
        }
        Iterator tit = pd.getTransitions().iterator();
        while (tit.hasNext()) {
            TransitionDefinition tr = (TransitionDefinition)tit.next();
            if (ad != tr.getSource()) continue;
            Expression exp = tr.getCondition();
            int type = tr.getType();
            if (type == 3) {
                if (!isExRaising) continue;
                result.add(tr);
                if (isConcurrent) continue;
                break;
            }
            if (type == 2) {
                otherwises.add(tr);
                continue;
            }
            if (exp == null) {
                result.add(tr);
                if (isConcurrent) continue;
                break;
            }
            if (!exp.eval(vars)) continue;
            result.add(tr);
            if (isConcurrent) continue;
            break;
        }
        if (result.size() == 0 && otherwises.size() > 0) {
            if (isConcurrent) {
                result = otherwises;
            } else {
                result.add((TransitionDefinition)otherwises.get(0));
            }
        }
        return result;
    }
}

