/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionRepositoryImpl;
import jp.co.argo21.nautica.workflow.engine.FormalParameterBean;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.InvalidRequesterException;
import jp.co.argo21.nautica.workflow.omg.NotEnabledException;
import jp.co.argo21.nautica.workflow.omg.RequesterRequiredException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfProcessManager;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.DurationHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.FormalParameter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import org.apache.log4j.Logger;

class ProcessManager
implements WfProcessManager {
    private static Logger eLog = LogManager.getEngineLogger();
    private String definitionID;
    private PackageDefinition packageDefifinition;
    private ProcessDefinition processDefinition;

    public ProcessManager(String pdid) throws InvalidProcessDefinitionException {
        this.definitionID = pdid;
        try {
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            this.packageDefifinition = rep.getPackageDefinition(pdid);
            this.processDefinition = rep.getProcessDefinition(pdid);
            this.init();
        }
        catch (Exception ex) {
            String E0149 = StringManager.get("E0149") + "(ProcessDefinitionID = " + pdid + ")";
            throw new InvalidProcessDefinitionException(E0149, ex);
        }
    }

    private void init() {
    }

    public int getProcessCount() throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            return procDAO.findCountByPDID(this.definitionID);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0150 = StringManager.get("E0150");
            throw new WorkflowException(E0150, ex);
        }
    }

    public WfProcess getProcess(String pid) throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            ProcessBean bean = procDAO.findByPDIDandPID(this.definitionID, pid);
            FormalParameter[] params = (FormalParameter[])this.getResultSignature();
            ProcessInternal proc = new ProcessInternal(bean, params);
            return proc;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0151 = StringManager.get("E0151") + "(ProcessID = " + pid + ")";
            throw new WorkflowException(E0151, ex);
        }
    }

    public WfProcess[] getAllProcesses() throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            ProcessBean[] beans = procDAO.findByPDID(this.definitionID);
            WfProcess[] procs = new ProcessInternal[beans.length];
            for (int i = 0; i < beans.length; ++i) {
                FormalParameter[] params = (FormalParameter[])this.getResultSignature();
                procs[i] = new ProcessInternal(beans[i], params);
            }
            return procs;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0159 = StringManager.get("E0159");
            throw new WorkflowException(E0159, ex);
        }
    }

    public boolean isMemberOfProcess(String member) throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            ProcessBean proc = procDAO.findByPDIDandPID(this.definitionID, member);
            return proc != null;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0152 = StringManager.get("E0152");
            throw new WorkflowException(E0152, ex);
        }
    }

    public String getCategory() throws WorkflowException {
        return this.packageDefifinition.getName();
    }

    public String getName() throws WorkflowException {
        return this.processDefinition.getName();
    }

    public String getVersion() throws WorkflowException {
        return this.packageDefifinition.getVersion();
    }

    public String getDescription() throws WorkflowException {
        return this.processDefinition.getDescription();
    }

    public WfState getState() throws WorkflowException {
        try {
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            return rep.getProcessDefinitionState(this.definitionID);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0154 = StringManager.get("E0154");
            throw new WorkflowException(E0154, ex);
        }
    }

    public void setState(WfState state) throws TransitionNotAllowedException, WorkflowException {
        try {
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            rep.setProcessDefinitionState(this.definitionID, (ProcessDefinitionState)state);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0155 = StringManager.get("E0155");
            throw new WorkflowException(E0155, ex);
        }
    }

    public WfNameValue[] getContextSignature() throws WorkflowException {
        List varDefs = this.packageDefifinition.getVariables();
        ArrayList<VariableBean> vars = new ArrayList<VariableBean>();
        Iterator it = varDefs.iterator();
        while (it.hasNext()) {
            VariableDefinition varDef = (VariableDefinition)it.next();
            VariableBean bean = new VariableBean();
            bean.setVariableDefinitionID(varDef.getID());
            bean.setName(varDef.getName());
            bean.setType(varDef.getType());
            bean.setValue(varDef.getInitialValue());
            vars.add(bean);
        }
        return vars.toArray(new VariableBean[vars.size()]);
    }

    public WfNameValue[] getResultSignature() throws WorkflowException {
        List paramDefs = this.processDefinition.getParameters();
        ArrayList<FormalParameterBean> params = new ArrayList<FormalParameterBean>();
        Iterator it = paramDefs.iterator();
        while (it.hasNext()) {
            ParameterDefinition paramDef = (ParameterDefinition)it.next();
            FormalParameterBean bean = new FormalParameterBean();
            bean.setID(paramDef.getID());
            bean.setName(paramDef.getName());
            bean.setType(paramDef.getType());
            bean.setMode(paramDef.getMode());
            bean.setDescription(paramDef.getDescription());
            params.add(bean);
        }
        return params.toArray(new FormalParameterBean[params.size()]);
    }

    public WfProcess createProcess(WfRequester requester, String name) throws NotEnabledException, InvalidRequesterException, RequesterRequiredException, WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO processDAO = daoFactory.getProcessDAO();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            long now = System.currentTimeMillis();
            ProcessBean processBean = this.insertProcess(processDAO, requester, name, now);
            VariableBean[] vars = (VariableBean[])this.getContextSignature();
            for (int i = 0; i < vars.length; ++i) {
                VariableBean variableBean = vars[i];
                this.insertVariable(variableDAO, processBean, variableBean, now);
            }
            FormalParameter[] params = (FormalParameter[])this.getResultSignature();
            ProcessInternal proc = new ProcessInternal(processBean, params);
            proc.setRequester(requester);
            return proc;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0153 = StringManager.get("E0153");
            throw new WorkflowException(E0153, ex);
        }
    }

    void changeProcessesState(Filter filter, ProcessState state) throws InvalidFilterException, InvalidStateException, TransitionNotAllowedException {
        try {
            Process[] procs = this.getProcesses(filter);
            for (int i = 0; i < procs.length; ++i) {
                String pid = procs[i].getID();
                ProcessInternal process = (ProcessInternal)this.getProcess(pid);
                process.changeState(state);
            }
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (InvalidStateException ex) {
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0156 = StringManager.get("E0156");
            throw new TransitionNotAllowedException(E0156, ex);
        }
    }

    void changeActivitiesState(String adid, Filter filter, ActivityState state) throws InvalidActivityNameException, InvalidFilterException, InvalidStateException, TransitionNotAllowedException {
        try {
            Activity[] acts = this.getActivities(adid, filter);
            for (int i = 0; i < acts.length; ++i) {
                String pid = acts[i].getProcessID();
                String aid = acts[i].getActivityID();
                ProcessInternal process = (ProcessInternal)this.getProcess(pid);
                WfActivity activity = process.getStep(aid);
                if (activity == null) {
                    String msg = StringManager.get("E0069");
                    throw new InvalidActivityInstanceException(msg);
                }
                activity.changeState(state);
            }
        }
        catch (InvalidActivityNameException ex) {
            throw ex;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (InvalidStateException ex) {
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0157 = StringManager.get("E0157");
            throw new TransitionNotAllowedException(E0157, ex);
        }
    }

    void terminateProcesses(Filter filter) throws InvalidProcessDefinitionException, InvalidFilterException {
        try {
            Process[] procs = this.getProcesses(filter);
            for (int i = 0; i < procs.length; ++i) {
                String pid = procs[i].getID();
                ProcessInternal process = (ProcessInternal)this.getProcess(pid);
                process.terminate();
            }
        }
        catch (InvalidProcessDefinitionException ex) {
            throw ex;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0136 = StringManager.get("E0136");
            throw new InvalidProcessDefinitionException(E0136, ex);
        }
    }

    void assignProcessesAttribute(Filter filter, Attribute attr) throws InvalidFilterException, InvalidAttributeException {
        try {
            Process[] procs = this.getProcesses(filter);
            for (int i = 0; i < procs.length; ++i) {
                String pid = procs[i].getID();
                VariableBean bean = new VariableBean();
                bean.setName(attr.getName());
                bean.setType(attr.getType());
                bean.setValue(attr.getValue());
                bean.setProcessID(pid);
                ProcessInternal process = (ProcessInternal)this.getProcess(pid);
                process.setContext(bean);
            }
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new InvalidAttributeException(E0080, ex);
        }
    }

    void assignActivitiesAttribute(String adid, Filter filter, Attribute attr) throws InvalidActivityNameException, InvalidFilterException, InvalidAttributeException {
        try {
            Activity[] acts = this.getActivities(adid, filter);
            for (int i = 0; i < acts.length; ++i) {
                String pid = acts[i].getProcessID();
                String aid = acts[i].getActivityID();
                VariableBean bean = new VariableBean();
                bean.setName(attr.getName());
                bean.setType(attr.getType());
                bean.setValue(attr.getValue());
                bean.setProcessID(pid);
                ProcessInternal process = (ProcessInternal)this.getProcess(pid);
                WfActivity activity = process.getStep(aid);
                if (activity == null) {
                    String msg = StringManager.get("E0069");
                    throw new InvalidActivityInstanceException(msg);
                }
                activity.setContext(bean);
            }
        }
        catch (InvalidActivityNameException ex) {
            throw ex;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0158 = StringManager.get("E0158");
            throw new InvalidAttributeException(E0158, ex);
        }
    }

    void abortProcesses(Filter filter) throws InvalidFilterException {
        try {
            Process[] procs = this.getProcesses(filter);
            for (int i = 0; i < procs.length; ++i) {
                String pid = procs[i].getID();
                ProcessInternal process = (ProcessInternal)this.getProcess(pid);
                process.abort();
            }
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0137 = StringManager.get("E0137");
            throw new InvalidFilterException(E0137, ex);
        }
    }

    Process[] getProcesses(Filter filter) throws InvalidFilterException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Process[] beans = procDAO.findByFilter(this.definitionID, filter);
            return beans;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0151 = StringManager.get("E0151");
            throw new InvalidFilterException(E0151, ex);
        }
    }

    Activity[] getActivities(String adid, Filter filter) throws InvalidFilterException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            Activity[] beans = actDAO.findByFilter(this.definitionID, adid, filter);
            return beans;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0124 = StringManager.get("E0124");
            throw new InvalidFilterException(E0124, ex);
        }
    }

    private ProcessBean insertProcess(ProcessDAO processDAO, WfRequester requester, String name, long now) throws Exception {
        Timestamp ts = DataAccessManager.getAccessTime();
        int du = this.processDefinition.getDurationUnit();
        int limit = this.processDefinition.getLimit();
        long durationLimit = now + DurationHelper.calculateDuration(du, limit);
        Timestamp limitTs = new Timestamp(durationLimit);
        String procName = name;
        if (procName == null) {
            procName = "";
        }
        ProcessBean processBean = new ProcessBean();
        processBean.setID(UniqueKeyGenerator.generate("PSI"));
        processBean.setName(name);
        processBean.setPackageID(this.packageDefifinition.getID());
        processBean.setProcDefinitionID(this.definitionID);
        processBean.setProcessState(ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.toInt());
        processBean.setStartDate(ts);
        processBean.setStarterID(requester.getReqesterResource().getID());
        processBean.setDurationLimit(limitTs);
        processBean.setUpdateDate(ts);
        processDAO.insert(processBean);
        return processBean;
    }

    private void insertVariable(VariableDAO variableDAO, ProcessBean processBean, VariableBean variableBean, long now) throws Exception {
        Timestamp ts = DataAccessManager.getAccessTime();
        variableBean.setID(UniqueKeyGenerator.generate("VRI"));
        variableBean.setProcessID(processBean.getID());
        variableBean.setUpdateDate(ts);
        variableDAO.insert(variableBean, null);
    }
}

