/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.MessageBroker;
import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import org.apache.log4j.Logger;

public class SystemMessageTransporter {
    private static final ThreadLocal manager = new ThreadLocal();
    private static Logger eLog = LogManager.getEngineLogger();
    private String queueName;

    static synchronized void execute() throws MessagingException {
        Map holders = (Map)manager.get();
        if (holders == null) {
            return;
        }
        MessageBroker broker = MessageBroker.getInstance();
        Set keys = holders.keySet();
        Iterator keyit = keys.iterator();
        while (keyit.hasNext()) {
            String key = (String)keyit.next();
            WorkflowMQ mq = broker.getWorkflowMQ(key);
            List holder = (List)holders.get(key);
            Iterator it = holder.iterator();
            while (it.hasNext()) {
                WorkflowMessage msg = (WorkflowMessage)it.next();
                mq.send(msg);
            }
            holder.clear();
        }
    }

    SystemMessageTransporter(String queueName) {
        this.queueName = queueName;
        Hashtable holders = (Hashtable)manager.get();
        if (holders == null) {
            holders = new Hashtable();
            manager.set(holders);
        }
        if (!holders.containsKey(queueName)) {
            ArrayList holder = new ArrayList();
            holders.put(queueName, holder);
        }
    }

    synchronized void sendMessage(WorkflowMessage msg) throws MessagingException {
        Map holders = (Map)manager.get();
        List holder = (List)holders.get(this.queueName);
        holder.add(msg);
    }
}

