/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.Iterator;
import javax.jms.JMSException;
import org.activemq.ActiveMQMessageConsumer;
import org.activemq.ActiveMQSession;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.util.MemoryBoundedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQSessionExecutor
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)ActiveMQSessionExecutor.class);
    private ActiveMQSession session;
    private MemoryBoundedQueue messageQueue;
    private boolean closed;
    private Thread runner;
    private boolean dispatchedBySessionPool;
    private boolean optimizedMessageDispatch;

    ActiveMQSessionExecutor(ActiveMQSession session, MemoryBoundedQueue queue) {
        this.session = session;
        this.messageQueue = queue;
    }

    void setDispatchedBySessionPool(boolean value) {
        this.dispatchedBySessionPool = value;
    }

    boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    void setOptimizedMessageDispatch(boolean optimizedMessageDispatch) {
        this.optimizedMessageDispatch = optimizedMessageDispatch;
    }

    void execute(ActiveMQMessage message) {
        if (this.optimizedMessageDispatch && !this.dispatchedBySessionPool) {
            this.dispatch(message);
        } else {
            this.messageQueue.enqueue(message);
        }
    }

    void executeFirst(ActiveMQMessage message) {
        this.messageQueue.enqueueFirstNoBlock(message);
    }

    boolean hasUncomsumedMessages() {
        return !this.messageQueue.isEmpty();
    }

    public void run() {
        while (!this.closed && !this.dispatchedBySessionPool) {
            ActiveMQMessage message = null;
            try {
                message = (ActiveMQMessage)this.messageQueue.dequeue(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.closed || message == null) continue;
            if (!this.dispatchedBySessionPool) {
                this.dispatch(message);
                continue;
            }
            this.messageQueue.enqueueFirstNoBlock(message);
        }
    }

    void dispatch(ActiveMQMessage message) {
        Iterator i = this.session.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            if (!message.isConsumerTarget(consumer.getConsumerNumber())) continue;
            try {
                consumer.processMessage(message.shallowCopy());
            }
            catch (JMSException e) {
                this.session.connection.handleAsyncException(e);
            }
        }
    }

    synchronized void start() {
        this.messageQueue.start();
        if (this.runner == null && (!this.dispatchedBySessionPool || this.optimizedMessageDispatch)) {
            this.runner = new Thread((Runnable)this, "JmsSessionDispatcher: " + this.session.getSessionId());
            this.runner.setPriority(10);
            this.runner.start();
        }
    }

    synchronized void stop() {
        this.messageQueue.stop();
    }

    synchronized void close() {
        this.closed = true;
        this.messageQueue.close();
    }

    void clear() {
        this.messageQueue.clear();
    }

    ActiveMQMessage dequeueNoWait() {
        try {
            return (ActiveMQMessage)this.messageQueue.dequeueNoWait();
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    protected void clearMessagesInProgress() {
        this.messageQueue.clear();
    }
}

