/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.activemq.advisories.ConnectionAdvisoryEvent;
import org.activemq.advisories.ConnectionAdvisoryEventListener;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConnectionInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionAdvisor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)ConnectionAdvisor.class);
    private Connection connection;
    private Session session;
    private List listeners = new CopyOnWriteArrayList();
    private Map activeConnections = new HashMap();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Object lock = new Object();

    public ConnectionAdvisor(Connection connection) throws JMSException {
        this.connection = connection;
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.session = this.connection.createSession(false, 1);
            String advisoryName = "ActiveMQ.Advisory.Connections.";
            ActiveMQTopic advisoryDestination = new ActiveMQTopic(advisoryName);
            MessageConsumer consumer = this.session.createConsumer((Destination)advisoryDestination);
            consumer.setMessageListener((MessageListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (this.started.commit(true, false)) {
            if (this.session != null) {
                this.session.close();
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public void addListener(ConnectionAdvisoryEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ConnectionAdvisoryEventListener l) {
        this.listeners.remove(l);
    }

    public boolean isActive(String clientId) {
        return this.activeConnections.containsKey(clientId);
    }

    public Set getConnections() {
        HashSet set = new HashSet();
        set.addAll(this.activeConnections.values());
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForActiveConnections(int number, long timeout) {
        int result = 0;
        long waitTime = timeout;
        long start = timeout <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.started.get() && (result = this.numberOfActiveConnections()) != number && waitTime > 0L) {
                try {
                    this.lock.wait(waitTime);
                }
                catch (Throwable e) {
                    log.debug((Object)"Interrupted", e);
                    e.printStackTrace();
                }
                waitTime = timeout - (System.currentTimeMillis() - start);
            }
        }
        return result;
    }

    public int numberOfActiveConnections() {
        return this.activeConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            try {
                ConnectionInfo info = (ConnectionInfo)((ObjectMessage)msg).getObject();
                ConnectionAdvisoryEvent event = new ConnectionAdvisoryEvent(info);
                if (!event.getInfo().isClosed()) {
                    this.activeConnections.put(event.getInfo().getClientId(), event.getInfo());
                } else {
                    this.activeConnections.remove(event.getInfo().getClientId());
                }
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                this.fireEvent(event);
            }
            catch (Throwable e) {
                log.error((Object)("Failed to process message: " + msg));
            }
        }
    }

    private void fireEvent(ConnectionAdvisoryEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConnectionAdvisoryEventListener l = (ConnectionAdvisoryEventListener)i.next();
            l.onEvent(event);
        }
    }
}

