/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.Filter;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.Dispatcher;
import org.activemq.service.MessageContainer;
import org.activemq.service.QueueListEntry;
import org.activemq.service.RedeliveryPolicy;
import org.activemq.service.TopicMessageContainer;
import org.activemq.service.TransactionManager;
import org.activemq.service.TransactionTask;
import org.activemq.service.impl.MessagePointer;
import org.activemq.service.impl.SubscriptionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableTopicSubscription
extends SubscriptionImpl {
    private static final Log log = LogFactory.getLog((Class)DurableTopicSubscription.class);
    private String persistentKey;

    public DurableTopicSubscription(Dispatcher dispatcher, BrokerClient client, ConsumerInfo info, Filter filter, RedeliveryPolicy redeliveryPolicy, DeadLetterPolicy deadLetterPolicy) {
        super(dispatcher, client, info, filter, redeliveryPolicy, deadLetterPolicy);
    }

    public synchronized void messageConsumed(MessageAck ack) throws JMSException {
        if (ack.isExpired() || !ack.isMessageRead() && !this.isBrowser()) {
            super.messageConsumed(ack);
        } else {
            final HashMap<MessageContainer, MessagePointer> lastMessagePointersPerContainer = new HashMap<MessageContainer, MessagePointer>();
            boolean found = false;
            QueueListEntry queueEntry = this.messagePtrs.getFirstEntry();
            while (queueEntry != null) {
                final MessagePointer pointer = (MessagePointer)queueEntry.getElement();
                this.messagePtrs.remove(queueEntry);
                lastMessagePointersPerContainer.put(pointer.getContainer(), pointer);
                this.unconsumedMessagesDispatched.decrement();
                TransactionManager.getContexTransaction().addPostRollbackTask(new TransactionTask(){

                    public void execute() throws Throwable {
                        DurableTopicSubscription.this.unconsumedMessagesDispatched.increment();
                        MessagePointer p = new MessagePointer(pointer);
                        p.setRedelivered(true);
                        DurableTopicSubscription.this.messagePtrs.add(p);
                        DurableTopicSubscription.this.dispatch.wakeup(DurableTopicSubscription.this);
                        DurableTopicSubscription.this.lastMessageIdentity = pointer.getMessageIdentity();
                    }
                });
                TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

                    public void execute() throws Throwable {
                        Iterator iter = lastMessagePointersPerContainer.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            TopicMessageContainer container = (TopicMessageContainer)entry.getKey();
                            MessagePointer pointer = (MessagePointer)entry.getValue();
                            container.setLastAcknowledgedMessageID(DurableTopicSubscription.this, pointer.getMessageIdentity());
                        }
                    }
                });
                if (pointer.getMessageIdentity().equals(ack.getMessageIdentity())) {
                    found = true;
                    break;
                }
                queueEntry = this.messagePtrs.getNextEntry(queueEntry);
            }
            if (!found) {
                log.warn((Object)("Did not find a matching message for identity: " + ack.getMessageIdentity()));
            }
            this.dispatch.wakeup(this);
        }
    }

    public String getPersistentKey() {
        if (this.persistentKey == null) {
            this.persistentKey = "[" + this.getClientId() + ":" + this.getSubscriberName() + "]";
        }
        return this.persistentKey;
    }
}

