/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerClient;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.MessageAck;
import org.activemq.service.Transaction;
import org.activemq.service.TransactionManager;
import org.activemq.service.impl.LocalTransactionCommand;
import org.activemq.service.impl.XATransactionCommand;
import org.activemq.store.TransactionStore;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionManagerImpl
extends TransactionManager {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerImpl.class);
    private Broker broker;
    private TransactionStore transactionStore;
    private Map activeClients = new ConcurrentHashMap();
    private Map localTxs = new ConcurrentHashMap();
    private Map xaTxs = new ConcurrentHashMap();

    public TransactionManagerImpl(Broker broker, TransactionStore transactionStore) {
        this.transactionStore = transactionStore;
        this.broker = broker;
    }

    public Transaction createLocalTransaction(BrokerClient client, String txid) throws JMSException {
        LocalTransactionCommand t = new LocalTransactionCommand(this.localTxs, txid, this.transactionStore);
        this.localTxs.put(txid, t);
        return t;
    }

    public Transaction createXATransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        Transaction tx = (Transaction)this.localTxs.get(xid);
        if (tx == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("XA Transaction started: " + xid));
            }
            tx = new XATransactionCommand(xid, this.xaTxs, this.transactionStore);
            this.xaTxs.put(xid, tx);
        }
        return tx;
    }

    public Transaction getLocalTransaction(String txid) throws JMSException {
        Transaction tx = (Transaction)this.localTxs.get(txid);
        if (tx == null) {
            throw new JMSException("Transaction '" + txid + "' has not been started.");
        }
        return tx;
    }

    public Transaction getXATransaction(ActiveMQXid xid) throws XAException {
        Transaction tx = (Transaction)this.xaTxs.get(xid);
        if (tx == null) {
            XAException e = new XAException("Transaction '" + xid + "' has not been started.");
            e.errorCode = -4;
            throw e;
        }
        return tx;
    }

    public ActiveMQXid[] getPreparedXATransactions() throws XAException {
        ArrayList<ActiveMQXid> txs = new ArrayList<ActiveMQXid>(this.xaTxs.size());
        Iterator iter = this.xaTxs.keySet().iterator();
        while (iter.hasNext()) {
            ActiveMQXid tx = (ActiveMQXid)iter.next();
            txs.add(tx);
        }
        ActiveMQXid[] rc = new ActiveMQXid[txs.size()];
        txs.toArray(rc);
        return rc;
    }

    public void cleanUpClient(BrokerClient client) throws JMSException {
        List list = (List)this.activeClients.remove(client);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    Transaction t;
                    Object o = list.get(i);
                    if (o instanceof String) {
                        t = this.getLocalTransaction((String)o);
                        t.rollback();
                        continue;
                    }
                    t = this.getXATransaction((ActiveMQXid)o);
                    t.rollback();
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)"ERROR Rolling back disconnected client's transactions: ", (Throwable)e);
                }
            }
            list.clear();
        }
    }

    public void recover(Transaction transaction) {
        if (transaction instanceof XATransactionCommand) {
            XATransactionCommand xaTransaction = (XATransactionCommand)transaction;
            xaTransaction.initialise(this.xaTxs, this.transactionStore);
            this.xaTxs.put(transaction.getTransactionId(), transaction);
        }
    }

    public void start() throws JMSException {
        this.transactionStore.start();
        try {
            this.transactionStore.recover(new TransactionStore.RecoveryListener(){

                public void recover(ActiveMQXid xid, ActiveMQMessage[] addedMessages, MessageAck[] aks) throws JMSException, XAException {
                    int i;
                    Transaction transaction = TransactionManagerImpl.this.createXATransaction(null, xid);
                    for (i = 0; i < addedMessages.length; ++i) {
                        TransactionManagerImpl.this.broker.sendMessage(null, addedMessages[i]);
                    }
                    for (i = 0; i < aks.length; ++i) {
                        TransactionManagerImpl.this.broker.acknowledgeMessage(null, aks[i]);
                    }
                }
            });
        }
        catch (XAException e) {
            throw JMSExceptionHelper.newJMSException("Recovery Failed: " + e.getMessage(), e);
        }
    }

    public void stop() throws JMSException {
        this.transactionStore.stop();
    }

    private void addActiveTransaction(BrokerClient client, Object transactionId) {
        ArrayList<Object> list = (ArrayList<Object>)this.activeClients.get(client);
        if (list == null) {
            list = new ArrayList<Object>();
            this.activeClients.put(client, list);
        }
        list.add(transactionId);
    }

    private void removeActiveTransaction(BrokerClient client, Object transactionId) {
        List list = (List)this.activeClients.get(client);
        if (list != null) {
            list.remove(transactionId);
        }
    }
}

