/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionContext {
    private static final Log log = LogFactory.getLog((Class)TransactionContext.class);
    private static ThreadLocal threadLocalTxn = new ThreadLocal();
    private final DataSource dataSource;

    TransactionContext(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static Connection popConnection() {
        Connection[] tx = (Connection[])threadLocalTxn.get();
        if (tx == null || tx[0] == null) {
            log.warn((Object)"Attempt to pop connection when no transaction in progress");
            return null;
        }
        Connection answer = tx[0];
        tx[0] = null;
        return answer;
    }

    public static void pushConnection(Connection connection) {
        Connection[] tx = (Connection[])threadLocalTxn.get();
        if (tx == null) {
            tx = new Connection[]{null};
            threadLocalTxn.set(tx);
        }
        if (tx[0] != null) {
            throw new IllegalStateException("A transaction is allready in progress");
        }
        tx[0] = connection;
    }

    public static Connection peekConnection() {
        Connection[] tx = (Connection[])threadLocalTxn.get();
        if (tx != null && tx[0] != null) {
            return tx[0];
        }
        return null;
    }
}

