/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.jms.JMSException;
import org.activeio.journal.RecordLocation;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageIdentity;
import org.activemq.service.TransactionManager;
import org.activemq.service.TransactionTask;
import org.activemq.store.MessageStore;
import org.activemq.store.RecoveryListener;
import org.activemq.store.cache.CacheMessageStore;
import org.activemq.store.cache.CacheMessageStoreAware;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.util.Callback;
import org.activemq.util.TransactionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalMessageStore
implements MessageStore,
CacheMessageStoreAware {
    private static final Log log = LogFactory.getLog((Class)JournalMessageStore.class);
    protected final JournalPersistenceAdapter peristenceAdapter;
    protected final MessageStore longTermStore;
    protected final String destinationName;
    protected final TransactionTemplate transactionTemplate;
    private RecordLocation nextMark;
    private LinkedHashMap addedMessageIds = new LinkedHashMap();
    private ArrayList removedMessageLocations = new ArrayList();
    private MessageStore cacheMessageStore = this;

    public JournalMessageStore(JournalPersistenceAdapter adapter, MessageStore checkpointStore, String destinationName) {
        this.peristenceAdapter = adapter;
        this.longTermStore = checkpointStore;
        this.destinationName = destinationName;
        this.transactionTemplate = new TransactionTemplate(adapter);
    }

    public void addMessage(final ActiveMQMessage message) throws JMSException {
        final RecordLocation location = this.peristenceAdapter.writePacket(this.destinationName, message, message.isReceiptRequired());
        TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Throwable {
                JournalMessageStore journalMessageStore = JournalMessageStore.this;
                synchronized (journalMessageStore) {
                    JournalMessageStore.this.nextMark = location;
                    MessageIdentity id = message.getJMSMessageIdentity();
                    JournalMessageStore.this.addedMessageIds.put(id, location);
                }
            }
        });
    }

    public void removeMessage(final MessageAck ack) throws JMSException {
        final RecordLocation ackLocation = this.peristenceAdapter.writePacket(this.destinationName, ack, ack.isReceiptRequired());
        TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Throwable {
                JournalMessageStore journalMessageStore = JournalMessageStore.this;
                synchronized (journalMessageStore) {
                    JournalMessageStore.this.nextMark = ackLocation;
                    MessageIdentity id = ack.getMessageIdentity();
                    if (JournalMessageStore.this.addedMessageIds.remove(id) == null) {
                        JournalMessageStore.this.removedMessageLocations.add(ack);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws JMSException {
        ArrayList cpRemovedMessageLocations;
        LinkedHashMap cpAddedMessageIds;
        RecordLocation rc;
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            rc = this.nextMark;
            cpAddedMessageIds = this.addedMessageIds;
            cpRemovedMessageLocations = this.removedMessageLocations;
            this.nextMark = null;
            this.addedMessageIds = new LinkedHashMap();
            this.removedMessageLocations = new ArrayList();
        }
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                Iterator<Object> iterator = cpAddedMessageIds.keySet().iterator();
                while (iterator.hasNext()) {
                    MessageIdentity identity = (MessageIdentity)iterator.next();
                    ActiveMQMessage msg = JournalMessageStore.this.getCacheMessage(identity);
                    if (msg == null) {
                        RecordLocation location = (RecordLocation)cpAddedMessageIds.get(identity);
                        msg = (ActiveMQMessage)JournalMessageStore.this.peristenceAdapter.readPacket(location);
                    }
                    if (msg != null) {
                        try {
                            JournalMessageStore.this.longTermStore.addMessage(msg);
                        }
                        catch (Throwable e) {
                            log.warn((Object)("Message could not be added to long term store: " + e.getMessage()), e);
                        }
                        continue;
                    }
                    log.warn((Object)("Journal could not reload message: " + identity));
                }
                iterator = cpRemovedMessageLocations.iterator();
                while (iterator.hasNext()) {
                    try {
                        MessageAck ack = (MessageAck)iterator.next();
                        JournalMessageStore.this.longTermStore.removeMessage(ack);
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Message could not be removed from long term store: " + e.getMessage()), e);
                    }
                }
            }
        });
        return rc;
    }

    private ActiveMQMessage getCacheMessage(MessageIdentity identity) throws JMSException {
        return this.cacheMessageStore.getMessage(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        Object location;
        ActiveMQMessage answer = null;
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            location = this.addedMessageIds.get(identity);
        }
        if (location != null) {
            try {
                answer = (ActiveMQMessage)this.peristenceAdapter.readPacket((RecordLocation)location);
                if (answer != null) {
                    return answer;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return this.longTermStore.getMessage(identity);
    }

    public void recover(RecoveryListener listener) throws JMSException {
        this.peristenceAdapter.checkpoint(true);
        this.longTermStore.recover(listener);
    }

    public void start() throws JMSException {
        this.longTermStore.start();
    }

    public void stop() throws JMSException {
        this.longTermStore.stop();
    }

    public MessageStore getLongTermMessageStore() {
        return this.longTermStore;
    }

    public void setCacheMessageStore(CacheMessageStore store) {
        this.cacheMessageStore = store;
        if (this.longTermStore instanceof CacheMessageStoreAware) {
            ((CacheMessageStoreAware)((Object)this.longTermStore)).setCacheMessageStore(store);
        }
    }

    public void removeAllMessages() throws JMSException {
        this.peristenceAdapter.checkpoint(true);
        this.longTermStore.removeAllMessages();
    }
}

