/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.transport.DiscoveryAgent;
import org.activemq.transport.DiscoveryTransportChannel;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.composite.CompositeTransportChannelFactory;
import org.activemq.util.BeanUtils;
import org.activemq.util.JMSExceptionHelper;
import org.activemq.util.URIHelper;

public abstract class DiscoveryTransportChannelFactorySupport
extends CompositeTransportChannelFactory {
    private DiscoveryAgent discoveryAgent;

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        if (this.discoveryAgent == null) {
            try {
                this.discoveryAgent = this.createDiscoveryAgent(remoteLocation);
            }
            catch (URISyntaxException e) {
                throw JMSExceptionHelper.newJMSException("Could not parse URI: " + remoteLocation + ". Reason: " + e, e);
            }
            this.discoveryAgent = this.populateAgentProperties(this.discoveryAgent, remoteLocation);
        }
        return new DiscoveryTransportChannel(wireFormat, this.discoveryAgent);
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    protected abstract DiscoveryAgent createDiscoveryAgent(URI var1) throws JMSException, URISyntaxException;

    protected DiscoveryAgent populateAgentProperties(DiscoveryAgent agent, URI uri) throws JMSException {
        Map properties = URIHelper.parseQuery(uri);
        if (!properties.isEmpty()) {
            BeanUtils.populate(agent, properties);
        }
        return agent;
    }
}

