/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import com.sun.script.javascript.RhinoScriptEngine;
import com.sun.script.util.ScriptEngineInfoBase;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.mozilla.javascript.Context;

public class RhinoScriptEngineFactory
extends ScriptEngineInfoBase
implements ScriptEngineFactory {
    public String[] getExtensions() {
        return new String[]{"js"};
    }

    public String[] getMimeTypes() {
        return new String[0];
    }

    public String[] getNames() {
        return new String[]{"js", "rhino"};
    }

    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return "javascript";
        }
        if (key.equals("javax.script.engine")) {
            return "Mozilla Rhino";
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getCurrentContext().getImplementationVersion();
        }
        if (key.equals("javax.script.language")) {
            return "ECMA Script";
        }
        if (key.equals("javax.script.language_version")) {
            return Integer.toString(this.getCurrentContext().getLanguageVersion());
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    public ScriptEngine getScriptEngine() {
        RhinoScriptEngine ret = new RhinoScriptEngine();
        ret.setEngineInfo(this);
        return ret;
    }

    public String getMethodCallSyntax(String obj, String method, String[] args) {
        String ret = obj + "." + method + "(";
        int len = args.length;
        if (len == 0) {
            ret = ret + ")";
            return ret;
        }
        for (int i = 0; i < len; ++i) {
            ret = ret + args[i];
            ret = i != len - 1 ? ret + "," : ret + ")";
        }
        return ret;
    }

    public String getOutputStatement(String toDisplay) {
        return "print(" + toDisplay + ")";
    }

    public String getProgram(String[] statements) {
        int len = statements.length;
        String ret = "";
        for (int i = 0; i < len; ++i) {
            ret = ret + statements[i] + ";";
        }
        return ret;
    }

    private Context getCurrentContext() {
        Context ctxt = null;
        ctxt = Context.getCurrentContext();
        if (null == ctxt) {
            ctxt = Context.enter();
            Context.exit();
        }
        return ctxt;
    }

    public static void main(String[] args) {
        RhinoScriptEngineFactory fact = new RhinoScriptEngineFactory();
        System.out.println(fact.getParameter("javax.script.engine_version"));
    }
}

